/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatasetStatusMessageCode {
    SUCCESS("SUCCESS"),
    SERVICE_ERROR("SERVICE_ERROR"),
    CLIENT_ERROR("CLIENT_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatasetStatusMessageCode> VALUE_MAP;
    private final String value;

    private DatasetStatusMessageCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatasetStatusMessageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatasetStatusMessageCode> knownValues() {
        EnumSet<DatasetStatusMessageCode> knownValues = EnumSet.allOf(DatasetStatusMessageCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatasetStatusMessageCode.class, DatasetStatusMessageCode::toString);
    }
}

