/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.CompareFacesMatch;
import software.amazon.awssdk.services.rekognition.model.CompareFacesMatchListCopier;
import software.amazon.awssdk.services.rekognition.model.CompareFacesUnmatchListCopier;
import software.amazon.awssdk.services.rekognition.model.ComparedFace;
import software.amazon.awssdk.services.rekognition.model.ComparedSourceImageFace;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompareFacesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, CompareFacesResponse> {
    private static final SdkField<ComparedSourceImageFace> SOURCE_IMAGE_FACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceImageFace").getter(CompareFacesResponse.getter(CompareFacesResponse::sourceImageFace)).setter(CompareFacesResponse.setter(Builder::sourceImageFace)).constructor(ComparedSourceImageFace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageFace").build()}).build();
    private static final SdkField<List<CompareFacesMatch>> FACE_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FaceMatches").getter(CompareFacesResponse.getter(CompareFacesResponse::faceMatches)).setter(CompareFacesResponse.setter(Builder::faceMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompareFacesMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ComparedFace>> UNMATCHED_FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnmatchedFaces").getter(CompareFacesResponse.getter(CompareFacesResponse::unmatchedFaces)).setter(CompareFacesResponse.setter(Builder::unmatchedFaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnmatchedFaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComparedFace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_IMAGE_ORIENTATION_CORRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceImageOrientationCorrection").getter(CompareFacesResponse.getter(CompareFacesResponse::sourceImageOrientationCorrectionAsString)).setter(CompareFacesResponse.setter(Builder::sourceImageOrientationCorrection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageOrientationCorrection").build()}).build();
    private static final SdkField<String> TARGET_IMAGE_ORIENTATION_CORRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetImageOrientationCorrection").getter(CompareFacesResponse.getter(CompareFacesResponse::targetImageOrientationCorrectionAsString)).setter(CompareFacesResponse.setter(Builder::targetImageOrientationCorrection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetImageOrientationCorrection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IMAGE_FACE_FIELD, FACE_MATCHES_FIELD, UNMATCHED_FACES_FIELD, SOURCE_IMAGE_ORIENTATION_CORRECTION_FIELD, TARGET_IMAGE_ORIENTATION_CORRECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CompareFacesResponse.memberNameToFieldInitializer();
    private final ComparedSourceImageFace sourceImageFace;
    private final List<CompareFacesMatch> faceMatches;
    private final List<ComparedFace> unmatchedFaces;
    private final String sourceImageOrientationCorrection;
    private final String targetImageOrientationCorrection;

    private CompareFacesResponse(BuilderImpl builder) {
        super(builder);
        this.sourceImageFace = builder.sourceImageFace;
        this.faceMatches = builder.faceMatches;
        this.unmatchedFaces = builder.unmatchedFaces;
        this.sourceImageOrientationCorrection = builder.sourceImageOrientationCorrection;
        this.targetImageOrientationCorrection = builder.targetImageOrientationCorrection;
    }

    public final ComparedSourceImageFace sourceImageFace() {
        return this.sourceImageFace;
    }

    public final boolean hasFaceMatches() {
        return this.faceMatches != null && !(this.faceMatches instanceof SdkAutoConstructList);
    }

    public final List<CompareFacesMatch> faceMatches() {
        return this.faceMatches;
    }

    public final boolean hasUnmatchedFaces() {
        return this.unmatchedFaces != null && !(this.unmatchedFaces instanceof SdkAutoConstructList);
    }

    public final List<ComparedFace> unmatchedFaces() {
        return this.unmatchedFaces;
    }

    public final OrientationCorrection sourceImageOrientationCorrection() {
        return OrientationCorrection.fromValue(this.sourceImageOrientationCorrection);
    }

    public final String sourceImageOrientationCorrectionAsString() {
        return this.sourceImageOrientationCorrection;
    }

    public final OrientationCorrection targetImageOrientationCorrection() {
        return OrientationCorrection.fromValue(this.targetImageOrientationCorrection);
    }

    public final String targetImageOrientationCorrectionAsString() {
        return this.targetImageOrientationCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceImageFace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFaceMatches() ? this.faceMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnmatchedFaces() ? this.unmatchedFaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceImageOrientationCorrectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetImageOrientationCorrectionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesResponse)) {
            return false;
        }
        CompareFacesResponse other = (CompareFacesResponse)((Object)obj);
        return Objects.equals(this.sourceImageFace(), other.sourceImageFace()) && this.hasFaceMatches() == other.hasFaceMatches() && Objects.equals(this.faceMatches(), other.faceMatches()) && this.hasUnmatchedFaces() == other.hasUnmatchedFaces() && Objects.equals(this.unmatchedFaces(), other.unmatchedFaces()) && Objects.equals(this.sourceImageOrientationCorrectionAsString(), other.sourceImageOrientationCorrectionAsString()) && Objects.equals(this.targetImageOrientationCorrectionAsString(), other.targetImageOrientationCorrectionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CompareFacesResponse").add("SourceImageFace", (Object)this.sourceImageFace()).add("FaceMatches", this.hasFaceMatches() ? this.faceMatches() : null).add("UnmatchedFaces", this.hasUnmatchedFaces() ? this.unmatchedFaces() : null).add("SourceImageOrientationCorrection", (Object)this.sourceImageOrientationCorrectionAsString()).add("TargetImageOrientationCorrection", (Object)this.targetImageOrientationCorrectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceImageFace": {
                return Optional.ofNullable(clazz.cast(this.sourceImageFace()));
            }
            case "FaceMatches": {
                return Optional.ofNullable(clazz.cast(this.faceMatches()));
            }
            case "UnmatchedFaces": {
                return Optional.ofNullable(clazz.cast(this.unmatchedFaces()));
            }
            case "SourceImageOrientationCorrection": {
                return Optional.ofNullable(clazz.cast(this.sourceImageOrientationCorrectionAsString()));
            }
            case "TargetImageOrientationCorrection": {
                return Optional.ofNullable(clazz.cast(this.targetImageOrientationCorrectionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceImageFace", SOURCE_IMAGE_FACE_FIELD);
        map.put("FaceMatches", FACE_MATCHES_FIELD);
        map.put("UnmatchedFaces", UNMATCHED_FACES_FIELD);
        map.put("SourceImageOrientationCorrection", SOURCE_IMAGE_ORIENTATION_CORRECTION_FIELD);
        map.put("TargetImageOrientationCorrection", TARGET_IMAGE_ORIENTATION_CORRECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompareFacesResponse, T> g) {
        return obj -> g.apply((CompareFacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private ComparedSourceImageFace sourceImageFace;
        private List<CompareFacesMatch> faceMatches = DefaultSdkAutoConstructList.getInstance();
        private List<ComparedFace> unmatchedFaces = DefaultSdkAutoConstructList.getInstance();
        private String sourceImageOrientationCorrection;
        private String targetImageOrientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFacesResponse model) {
            super(model);
            this.sourceImageFace(model.sourceImageFace);
            this.faceMatches(model.faceMatches);
            this.unmatchedFaces(model.unmatchedFaces);
            this.sourceImageOrientationCorrection(model.sourceImageOrientationCorrection);
            this.targetImageOrientationCorrection(model.targetImageOrientationCorrection);
        }

        public final ComparedSourceImageFace.Builder getSourceImageFace() {
            return this.sourceImageFace != null ? this.sourceImageFace.toBuilder() : null;
        }

        public final void setSourceImageFace(ComparedSourceImageFace.BuilderImpl sourceImageFace) {
            this.sourceImageFace = sourceImageFace != null ? sourceImageFace.build() : null;
        }

        @Override
        public final Builder sourceImageFace(ComparedSourceImageFace sourceImageFace) {
            this.sourceImageFace = sourceImageFace;
            return this;
        }

        public final List<CompareFacesMatch.Builder> getFaceMatches() {
            List<CompareFacesMatch.Builder> result = CompareFacesMatchListCopier.copyToBuilder(this.faceMatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFaceMatches(Collection<CompareFacesMatch.BuilderImpl> faceMatches) {
            this.faceMatches = CompareFacesMatchListCopier.copyFromBuilder(faceMatches);
        }

        @Override
        public final Builder faceMatches(Collection<CompareFacesMatch> faceMatches) {
            this.faceMatches = CompareFacesMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(CompareFacesMatch ... faceMatches) {
            this.faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(Consumer<CompareFacesMatch.Builder> ... faceMatches) {
            this.faceMatches(Stream.of(faceMatches).map(c -> (CompareFacesMatch)((CompareFacesMatch.Builder)CompareFacesMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ComparedFace.Builder> getUnmatchedFaces() {
            List<ComparedFace.Builder> result = CompareFacesUnmatchListCopier.copyToBuilder(this.unmatchedFaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnmatchedFaces(Collection<ComparedFace.BuilderImpl> unmatchedFaces) {
            this.unmatchedFaces = CompareFacesUnmatchListCopier.copyFromBuilder(unmatchedFaces);
        }

        @Override
        public final Builder unmatchedFaces(Collection<ComparedFace> unmatchedFaces) {
            this.unmatchedFaces = CompareFacesUnmatchListCopier.copy(unmatchedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unmatchedFaces(ComparedFace ... unmatchedFaces) {
            this.unmatchedFaces(Arrays.asList(unmatchedFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unmatchedFaces(Consumer<ComparedFace.Builder> ... unmatchedFaces) {
            this.unmatchedFaces(Stream.of(unmatchedFaces).map(c -> (ComparedFace)((ComparedFace.Builder)ComparedFace.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceImageOrientationCorrection() {
            return this.sourceImageOrientationCorrection;
        }

        public final void setSourceImageOrientationCorrection(String sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection = sourceImageOrientationCorrection;
        }

        @Override
        public final Builder sourceImageOrientationCorrection(String sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection = sourceImageOrientationCorrection;
            return this;
        }

        @Override
        public final Builder sourceImageOrientationCorrection(OrientationCorrection sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection(sourceImageOrientationCorrection == null ? null : sourceImageOrientationCorrection.toString());
            return this;
        }

        public final String getTargetImageOrientationCorrection() {
            return this.targetImageOrientationCorrection;
        }

        public final void setTargetImageOrientationCorrection(String targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection = targetImageOrientationCorrection;
        }

        @Override
        public final Builder targetImageOrientationCorrection(String targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection = targetImageOrientationCorrection;
            return this;
        }

        @Override
        public final Builder targetImageOrientationCorrection(OrientationCorrection targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection(targetImageOrientationCorrection == null ? null : targetImageOrientationCorrection.toString());
            return this;
        }

        @Override
        public CompareFacesResponse build() {
            return new CompareFacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CompareFacesResponse> {
        public Builder sourceImageFace(ComparedSourceImageFace var1);

        default public Builder sourceImageFace(Consumer<ComparedSourceImageFace.Builder> sourceImageFace) {
            return this.sourceImageFace((ComparedSourceImageFace)((ComparedSourceImageFace.Builder)ComparedSourceImageFace.builder().applyMutation(sourceImageFace)).build());
        }

        public Builder faceMatches(Collection<CompareFacesMatch> var1);

        public Builder faceMatches(CompareFacesMatch ... var1);

        public Builder faceMatches(Consumer<CompareFacesMatch.Builder> ... var1);

        public Builder unmatchedFaces(Collection<ComparedFace> var1);

        public Builder unmatchedFaces(ComparedFace ... var1);

        public Builder unmatchedFaces(Consumer<ComparedFace.Builder> ... var1);

        public Builder sourceImageOrientationCorrection(String var1);

        public Builder sourceImageOrientationCorrection(OrientationCorrection var1);

        public Builder targetImageOrientationCorrection(String var1);

        public Builder targetImageOrientationCorrection(OrientationCorrection var1);
    }
}

