/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.ProjectVersionDescription;
import software.amazon.awssdk.services.rekognition.model.ProjectVersionDescriptionsCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProjectVersionsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DescribeProjectVersionsResponse> {
    private static final SdkField<List<ProjectVersionDescription>> PROJECT_VERSION_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProjectVersionDescriptions").getter(DescribeProjectVersionsResponse.getter(DescribeProjectVersionsResponse::projectVersionDescriptions)).setter(DescribeProjectVersionsResponse.setter(Builder::projectVersionDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectVersionDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectVersionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeProjectVersionsResponse.getter(DescribeProjectVersionsResponse::nextToken)).setter(DescribeProjectVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_VERSION_DESCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProjectVersionDescriptions", PROJECT_VERSION_DESCRIPTIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ProjectVersionDescription> projectVersionDescriptions;
    private final String nextToken;

    private DescribeProjectVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.projectVersionDescriptions = builder.projectVersionDescriptions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProjectVersionDescriptions() {
        return this.projectVersionDescriptions != null && !(this.projectVersionDescriptions instanceof SdkAutoConstructList);
    }

    public final List<ProjectVersionDescription> projectVersionDescriptions() {
        return this.projectVersionDescriptions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectVersionDescriptions() ? this.projectVersionDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectVersionsResponse)) {
            return false;
        }
        DescribeProjectVersionsResponse other = (DescribeProjectVersionsResponse)((Object)obj);
        return this.hasProjectVersionDescriptions() == other.hasProjectVersionDescriptions() && Objects.equals(this.projectVersionDescriptions(), other.projectVersionDescriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProjectVersionsResponse").add("ProjectVersionDescriptions", this.hasProjectVersionDescriptions() ? this.projectVersionDescriptions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectVersionDescriptions": {
                return Optional.ofNullable(clazz.cast(this.projectVersionDescriptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectVersionsResponse, T> g) {
        return obj -> g.apply((DescribeProjectVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<ProjectVersionDescription> projectVersionDescriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectVersionsResponse model) {
            super(model);
            this.projectVersionDescriptions(model.projectVersionDescriptions);
            this.nextToken(model.nextToken);
        }

        public final List<ProjectVersionDescription.Builder> getProjectVersionDescriptions() {
            List<ProjectVersionDescription.Builder> result = ProjectVersionDescriptionsCopier.copyToBuilder(this.projectVersionDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectVersionDescriptions(Collection<ProjectVersionDescription.BuilderImpl> projectVersionDescriptions) {
            this.projectVersionDescriptions = ProjectVersionDescriptionsCopier.copyFromBuilder(projectVersionDescriptions);
        }

        @Override
        public final Builder projectVersionDescriptions(Collection<ProjectVersionDescription> projectVersionDescriptions) {
            this.projectVersionDescriptions = ProjectVersionDescriptionsCopier.copy(projectVersionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectVersionDescriptions(ProjectVersionDescription ... projectVersionDescriptions) {
            this.projectVersionDescriptions(Arrays.asList(projectVersionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectVersionDescriptions(Consumer<ProjectVersionDescription.Builder> ... projectVersionDescriptions) {
            this.projectVersionDescriptions(Stream.of(projectVersionDescriptions).map(c -> (ProjectVersionDescription)((ProjectVersionDescription.Builder)ProjectVersionDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeProjectVersionsResponse build() {
            return new DescribeProjectVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProjectVersionsResponse> {
        public Builder projectVersionDescriptions(Collection<ProjectVersionDescription> var1);

        public Builder projectVersionDescriptions(ProjectVersionDescription ... var1);

        public Builder projectVersionDescriptions(Consumer<ProjectVersionDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

