/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.KinesisDataStream;
import software.amazon.awssdk.services.rekognition.model.S3Destination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamProcessorOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamProcessorOutput> {
    private static final SdkField<KinesisDataStream> KINESIS_DATA_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisDataStream").getter(StreamProcessorOutput.getter(StreamProcessorOutput::kinesisDataStream)).setter(StreamProcessorOutput.setter(Builder::kinesisDataStream)).constructor(KinesisDataStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisDataStream").build()}).build();
    private static final SdkField<S3Destination> S3_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Destination").getter(StreamProcessorOutput.getter(StreamProcessorOutput::s3Destination)).setter(StreamProcessorOutput.setter(Builder::s3Destination)).constructor(S3Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KINESIS_DATA_STREAM_FIELD, S3_DESTINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KinesisDataStream", KINESIS_DATA_STREAM_FIELD);
            this.put("S3Destination", S3_DESTINATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final KinesisDataStream kinesisDataStream;
    private final S3Destination s3Destination;

    private StreamProcessorOutput(BuilderImpl builder) {
        this.kinesisDataStream = builder.kinesisDataStream;
        this.s3Destination = builder.s3Destination;
    }

    public final KinesisDataStream kinesisDataStream() {
        return this.kinesisDataStream;
    }

    public final S3Destination s3Destination() {
        return this.s3Destination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisDataStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessorOutput)) {
            return false;
        }
        StreamProcessorOutput other = (StreamProcessorOutput)obj;
        return Objects.equals(this.kinesisDataStream(), other.kinesisDataStream()) && Objects.equals(this.s3Destination(), other.s3Destination());
    }

    public final String toString() {
        return ToString.builder((String)"StreamProcessorOutput").add("KinesisDataStream", (Object)this.kinesisDataStream()).add("S3Destination", (Object)this.s3Destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KinesisDataStream": {
                return Optional.ofNullable(clazz.cast(this.kinesisDataStream()));
            }
            case "S3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StreamProcessorOutput, T> g) {
        return obj -> g.apply((StreamProcessorOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private KinesisDataStream kinesisDataStream;
        private S3Destination s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessorOutput model) {
            this.kinesisDataStream(model.kinesisDataStream);
            this.s3Destination(model.s3Destination);
        }

        public final KinesisDataStream.Builder getKinesisDataStream() {
            return this.kinesisDataStream != null ? this.kinesisDataStream.toBuilder() : null;
        }

        public final void setKinesisDataStream(KinesisDataStream.BuilderImpl kinesisDataStream) {
            this.kinesisDataStream = kinesisDataStream != null ? kinesisDataStream.build() : null;
        }

        @Override
        public final Builder kinesisDataStream(KinesisDataStream kinesisDataStream) {
            this.kinesisDataStream = kinesisDataStream;
            return this;
        }

        public final S3Destination.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(S3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public final Builder s3Destination(S3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public StreamProcessorOutput build() {
            return new StreamProcessorOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamProcessorOutput> {
        public Builder kinesisDataStream(KinesisDataStream var1);

        default public Builder kinesisDataStream(Consumer<KinesisDataStream.Builder> kinesisDataStream) {
            return this.kinesisDataStream((KinesisDataStream)((KinesisDataStream.Builder)KinesisDataStream.builder().applyMutation(kinesisDataStream)).build());
        }

        public Builder s3Destination(S3Destination var1);

        default public Builder s3Destination(Consumer<S3Destination.Builder> s3Destination) {
            return this.s3Destination((S3Destination)((S3Destination.Builder)S3Destination.builder().applyMutation(s3Destination)).build());
        }
    }
}

