/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.ContentType;
import software.amazon.awssdk.services.rekognition.model.ContentTypesCopier;
import software.amazon.awssdk.services.rekognition.model.ModerationLabel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentModerationDetection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentModerationDetection> {
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Timestamp").getter(ContentModerationDetection.getter(ContentModerationDetection::timestamp)).setter(ContentModerationDetection.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<ModerationLabel> MODERATION_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModerationLabel").getter(ContentModerationDetection.getter(ContentModerationDetection::moderationLabel)).setter(ContentModerationDetection.setter(Builder::moderationLabel)).constructor(ModerationLabel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModerationLabel").build()}).build();
    private static final SdkField<Long> START_TIMESTAMP_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("StartTimestampMillis").getter(ContentModerationDetection.getter(ContentModerationDetection::startTimestampMillis)).setter(ContentModerationDetection.setter(Builder::startTimestampMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestampMillis").build()}).build();
    private static final SdkField<Long> END_TIMESTAMP_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EndTimestampMillis").getter(ContentModerationDetection.getter(ContentModerationDetection::endTimestampMillis)).setter(ContentModerationDetection.setter(Builder::endTimestampMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestampMillis").build()}).build();
    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationMillis").getter(ContentModerationDetection.getter(ContentModerationDetection::durationMillis)).setter(ContentModerationDetection.setter(Builder::durationMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()}).build();
    private static final SdkField<List<ContentType>> CONTENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContentTypes").getter(ContentModerationDetection.getter(ContentModerationDetection::contentTypes)).setter(ContentModerationDetection.setter(Builder::contentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContentType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, MODERATION_LABEL_FIELD, START_TIMESTAMP_MILLIS_FIELD, END_TIMESTAMP_MILLIS_FIELD, DURATION_MILLIS_FIELD, CONTENT_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long timestamp;
    private final ModerationLabel moderationLabel;
    private final Long startTimestampMillis;
    private final Long endTimestampMillis;
    private final Long durationMillis;
    private final List<ContentType> contentTypes;

    private ContentModerationDetection(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.moderationLabel = builder.moderationLabel;
        this.startTimestampMillis = builder.startTimestampMillis;
        this.endTimestampMillis = builder.endTimestampMillis;
        this.durationMillis = builder.durationMillis;
        this.contentTypes = builder.contentTypes;
    }

    public final Long timestamp() {
        return this.timestamp;
    }

    public final ModerationLabel moderationLabel() {
        return this.moderationLabel;
    }

    public final Long startTimestampMillis() {
        return this.startTimestampMillis;
    }

    public final Long endTimestampMillis() {
        return this.endTimestampMillis;
    }

    public final Long durationMillis() {
        return this.durationMillis;
    }

    public final boolean hasContentTypes() {
        return this.contentTypes != null && !(this.contentTypes instanceof SdkAutoConstructList);
    }

    public final List<ContentType> contentTypes() {
        return this.contentTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.moderationLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestampMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestampMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContentTypes() ? this.contentTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentModerationDetection)) {
            return false;
        }
        ContentModerationDetection other = (ContentModerationDetection)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.moderationLabel(), other.moderationLabel()) && Objects.equals(this.startTimestampMillis(), other.startTimestampMillis()) && Objects.equals(this.endTimestampMillis(), other.endTimestampMillis()) && Objects.equals(this.durationMillis(), other.durationMillis()) && this.hasContentTypes() == other.hasContentTypes() && Objects.equals(this.contentTypes(), other.contentTypes());
    }

    public final String toString() {
        return ToString.builder((String)"ContentModerationDetection").add("Timestamp", (Object)this.timestamp()).add("ModerationLabel", (Object)this.moderationLabel()).add("StartTimestampMillis", (Object)this.startTimestampMillis()).add("EndTimestampMillis", (Object)this.endTimestampMillis()).add("DurationMillis", (Object)this.durationMillis()).add("ContentTypes", this.hasContentTypes() ? this.contentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "ModerationLabel": {
                return Optional.ofNullable(clazz.cast(this.moderationLabel()));
            }
            case "StartTimestampMillis": {
                return Optional.ofNullable(clazz.cast(this.startTimestampMillis()));
            }
            case "EndTimestampMillis": {
                return Optional.ofNullable(clazz.cast(this.endTimestampMillis()));
            }
            case "DurationMillis": {
                return Optional.ofNullable(clazz.cast(this.durationMillis()));
            }
            case "ContentTypes": {
                return Optional.ofNullable(clazz.cast(this.contentTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentModerationDetection, T> g) {
        return obj -> g.apply((ContentModerationDetection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long timestamp;
        private ModerationLabel moderationLabel;
        private Long startTimestampMillis;
        private Long endTimestampMillis;
        private Long durationMillis;
        private List<ContentType> contentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContentModerationDetection model) {
            this.timestamp(model.timestamp);
            this.moderationLabel(model.moderationLabel);
            this.startTimestampMillis(model.startTimestampMillis);
            this.endTimestampMillis(model.endTimestampMillis);
            this.durationMillis(model.durationMillis);
            this.contentTypes(model.contentTypes);
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final ModerationLabel.Builder getModerationLabel() {
            return this.moderationLabel != null ? this.moderationLabel.toBuilder() : null;
        }

        public final void setModerationLabel(ModerationLabel.BuilderImpl moderationLabel) {
            this.moderationLabel = moderationLabel != null ? moderationLabel.build() : null;
        }

        @Override
        public final Builder moderationLabel(ModerationLabel moderationLabel) {
            this.moderationLabel = moderationLabel;
            return this;
        }

        public final Long getStartTimestampMillis() {
            return this.startTimestampMillis;
        }

        public final void setStartTimestampMillis(Long startTimestampMillis) {
            this.startTimestampMillis = startTimestampMillis;
        }

        @Override
        public final Builder startTimestampMillis(Long startTimestampMillis) {
            this.startTimestampMillis = startTimestampMillis;
            return this;
        }

        public final Long getEndTimestampMillis() {
            return this.endTimestampMillis;
        }

        public final void setEndTimestampMillis(Long endTimestampMillis) {
            this.endTimestampMillis = endTimestampMillis;
        }

        @Override
        public final Builder endTimestampMillis(Long endTimestampMillis) {
            this.endTimestampMillis = endTimestampMillis;
            return this;
        }

        public final Long getDurationMillis() {
            return this.durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final List<ContentType.Builder> getContentTypes() {
            List<ContentType.Builder> result = ContentTypesCopier.copyToBuilder(this.contentTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContentTypes(Collection<ContentType.BuilderImpl> contentTypes) {
            this.contentTypes = ContentTypesCopier.copyFromBuilder(contentTypes);
        }

        @Override
        public final Builder contentTypes(Collection<ContentType> contentTypes) {
            this.contentTypes = ContentTypesCopier.copy(contentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentTypes(ContentType ... contentTypes) {
            this.contentTypes(Arrays.asList(contentTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentTypes(Consumer<ContentType.Builder> ... contentTypes) {
            this.contentTypes(Stream.of(contentTypes).map(c -> (ContentType)((ContentType.Builder)ContentType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ContentModerationDetection build() {
            return new ContentModerationDetection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentModerationDetection> {
        public Builder timestamp(Long var1);

        public Builder moderationLabel(ModerationLabel var1);

        default public Builder moderationLabel(Consumer<ModerationLabel.Builder> moderationLabel) {
            return this.moderationLabel((ModerationLabel)((ModerationLabel.Builder)ModerationLabel.builder().applyMutation(moderationLabel)).build());
        }

        public Builder startTimestampMillis(Long var1);

        public Builder endTimestampMillis(Long var1);

        public Builder durationMillis(Long var1);

        public Builder contentTypes(Collection<ContentType> var1);

        public Builder contentTypes(ContentType ... var1);

        public Builder contentTypes(Consumer<ContentType.Builder> ... var1);
    }
}

