/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.GeneralLabelsFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeneralLabelsSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeneralLabelsSettings> {
    private static final SdkField<List<String>> LABEL_INCLUSION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LabelInclusionFilters").getter(GeneralLabelsSettings.getter(GeneralLabelsSettings::labelInclusionFilters)).setter(GeneralLabelsSettings.setter(Builder::labelInclusionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelInclusionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LABEL_EXCLUSION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LabelExclusionFilters").getter(GeneralLabelsSettings.getter(GeneralLabelsSettings::labelExclusionFilters)).setter(GeneralLabelsSettings.setter(Builder::labelExclusionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelExclusionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LABEL_CATEGORY_INCLUSION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LabelCategoryInclusionFilters").getter(GeneralLabelsSettings.getter(GeneralLabelsSettings::labelCategoryInclusionFilters)).setter(GeneralLabelsSettings.setter(Builder::labelCategoryInclusionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCategoryInclusionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LABEL_CATEGORY_EXCLUSION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LabelCategoryExclusionFilters").getter(GeneralLabelsSettings.getter(GeneralLabelsSettings::labelCategoryExclusionFilters)).setter(GeneralLabelsSettings.setter(Builder::labelCategoryExclusionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCategoryExclusionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_INCLUSION_FILTERS_FIELD, LABEL_EXCLUSION_FILTERS_FIELD, LABEL_CATEGORY_INCLUSION_FILTERS_FIELD, LABEL_CATEGORY_EXCLUSION_FILTERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> labelInclusionFilters;
    private final List<String> labelExclusionFilters;
    private final List<String> labelCategoryInclusionFilters;
    private final List<String> labelCategoryExclusionFilters;

    private GeneralLabelsSettings(BuilderImpl builder) {
        this.labelInclusionFilters = builder.labelInclusionFilters;
        this.labelExclusionFilters = builder.labelExclusionFilters;
        this.labelCategoryInclusionFilters = builder.labelCategoryInclusionFilters;
        this.labelCategoryExclusionFilters = builder.labelCategoryExclusionFilters;
    }

    public final boolean hasLabelInclusionFilters() {
        return this.labelInclusionFilters != null && !(this.labelInclusionFilters instanceof SdkAutoConstructList);
    }

    public final List<String> labelInclusionFilters() {
        return this.labelInclusionFilters;
    }

    public final boolean hasLabelExclusionFilters() {
        return this.labelExclusionFilters != null && !(this.labelExclusionFilters instanceof SdkAutoConstructList);
    }

    public final List<String> labelExclusionFilters() {
        return this.labelExclusionFilters;
    }

    public final boolean hasLabelCategoryInclusionFilters() {
        return this.labelCategoryInclusionFilters != null && !(this.labelCategoryInclusionFilters instanceof SdkAutoConstructList);
    }

    public final List<String> labelCategoryInclusionFilters() {
        return this.labelCategoryInclusionFilters;
    }

    public final boolean hasLabelCategoryExclusionFilters() {
        return this.labelCategoryExclusionFilters != null && !(this.labelCategoryExclusionFilters instanceof SdkAutoConstructList);
    }

    public final List<String> labelCategoryExclusionFilters() {
        return this.labelCategoryExclusionFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabelInclusionFilters() ? this.labelInclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabelExclusionFilters() ? this.labelExclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabelCategoryInclusionFilters() ? this.labelCategoryInclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabelCategoryExclusionFilters() ? this.labelCategoryExclusionFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneralLabelsSettings)) {
            return false;
        }
        GeneralLabelsSettings other = (GeneralLabelsSettings)obj;
        return this.hasLabelInclusionFilters() == other.hasLabelInclusionFilters() && Objects.equals(this.labelInclusionFilters(), other.labelInclusionFilters()) && this.hasLabelExclusionFilters() == other.hasLabelExclusionFilters() && Objects.equals(this.labelExclusionFilters(), other.labelExclusionFilters()) && this.hasLabelCategoryInclusionFilters() == other.hasLabelCategoryInclusionFilters() && Objects.equals(this.labelCategoryInclusionFilters(), other.labelCategoryInclusionFilters()) && this.hasLabelCategoryExclusionFilters() == other.hasLabelCategoryExclusionFilters() && Objects.equals(this.labelCategoryExclusionFilters(), other.labelCategoryExclusionFilters());
    }

    public final String toString() {
        return ToString.builder((String)"GeneralLabelsSettings").add("LabelInclusionFilters", this.hasLabelInclusionFilters() ? this.labelInclusionFilters() : null).add("LabelExclusionFilters", this.hasLabelExclusionFilters() ? this.labelExclusionFilters() : null).add("LabelCategoryInclusionFilters", this.hasLabelCategoryInclusionFilters() ? this.labelCategoryInclusionFilters() : null).add("LabelCategoryExclusionFilters", this.hasLabelCategoryExclusionFilters() ? this.labelCategoryExclusionFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelInclusionFilters": {
                return Optional.ofNullable(clazz.cast(this.labelInclusionFilters()));
            }
            case "LabelExclusionFilters": {
                return Optional.ofNullable(clazz.cast(this.labelExclusionFilters()));
            }
            case "LabelCategoryInclusionFilters": {
                return Optional.ofNullable(clazz.cast(this.labelCategoryInclusionFilters()));
            }
            case "LabelCategoryExclusionFilters": {
                return Optional.ofNullable(clazz.cast(this.labelCategoryExclusionFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeneralLabelsSettings, T> g) {
        return obj -> g.apply((GeneralLabelsSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> labelInclusionFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> labelExclusionFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> labelCategoryInclusionFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> labelCategoryExclusionFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeneralLabelsSettings model) {
            this.labelInclusionFilters(model.labelInclusionFilters);
            this.labelExclusionFilters(model.labelExclusionFilters);
            this.labelCategoryInclusionFilters(model.labelCategoryInclusionFilters);
            this.labelCategoryExclusionFilters(model.labelCategoryExclusionFilters);
        }

        public final Collection<String> getLabelInclusionFilters() {
            if (this.labelInclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labelInclusionFilters;
        }

        public final void setLabelInclusionFilters(Collection<String> labelInclusionFilters) {
            this.labelInclusionFilters = GeneralLabelsFilterListCopier.copy(labelInclusionFilters);
        }

        @Override
        public final Builder labelInclusionFilters(Collection<String> labelInclusionFilters) {
            this.labelInclusionFilters = GeneralLabelsFilterListCopier.copy(labelInclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelInclusionFilters(String ... labelInclusionFilters) {
            this.labelInclusionFilters(Arrays.asList(labelInclusionFilters));
            return this;
        }

        public final Collection<String> getLabelExclusionFilters() {
            if (this.labelExclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labelExclusionFilters;
        }

        public final void setLabelExclusionFilters(Collection<String> labelExclusionFilters) {
            this.labelExclusionFilters = GeneralLabelsFilterListCopier.copy(labelExclusionFilters);
        }

        @Override
        public final Builder labelExclusionFilters(Collection<String> labelExclusionFilters) {
            this.labelExclusionFilters = GeneralLabelsFilterListCopier.copy(labelExclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelExclusionFilters(String ... labelExclusionFilters) {
            this.labelExclusionFilters(Arrays.asList(labelExclusionFilters));
            return this;
        }

        public final Collection<String> getLabelCategoryInclusionFilters() {
            if (this.labelCategoryInclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labelCategoryInclusionFilters;
        }

        public final void setLabelCategoryInclusionFilters(Collection<String> labelCategoryInclusionFilters) {
            this.labelCategoryInclusionFilters = GeneralLabelsFilterListCopier.copy(labelCategoryInclusionFilters);
        }

        @Override
        public final Builder labelCategoryInclusionFilters(Collection<String> labelCategoryInclusionFilters) {
            this.labelCategoryInclusionFilters = GeneralLabelsFilterListCopier.copy(labelCategoryInclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelCategoryInclusionFilters(String ... labelCategoryInclusionFilters) {
            this.labelCategoryInclusionFilters(Arrays.asList(labelCategoryInclusionFilters));
            return this;
        }

        public final Collection<String> getLabelCategoryExclusionFilters() {
            if (this.labelCategoryExclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labelCategoryExclusionFilters;
        }

        public final void setLabelCategoryExclusionFilters(Collection<String> labelCategoryExclusionFilters) {
            this.labelCategoryExclusionFilters = GeneralLabelsFilterListCopier.copy(labelCategoryExclusionFilters);
        }

        @Override
        public final Builder labelCategoryExclusionFilters(Collection<String> labelCategoryExclusionFilters) {
            this.labelCategoryExclusionFilters = GeneralLabelsFilterListCopier.copy(labelCategoryExclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelCategoryExclusionFilters(String ... labelCategoryExclusionFilters) {
            this.labelCategoryExclusionFilters(Arrays.asList(labelCategoryExclusionFilters));
            return this;
        }

        public GeneralLabelsSettings build() {
            return new GeneralLabelsSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeneralLabelsSettings> {
        public Builder labelInclusionFilters(Collection<String> var1);

        public Builder labelInclusionFilters(String ... var1);

        public Builder labelExclusionFilters(Collection<String> var1);

        public Builder labelExclusionFilters(String ... var1);

        public Builder labelCategoryInclusionFilters(Collection<String> var1);

        public Builder labelCategoryInclusionFilters(String ... var1);

        public Builder labelCategoryExclusionFilters(Collection<String> var1);

        public Builder labelCategoryExclusionFilters(String ... var1);
    }
}

