/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.AssociatedFace;
import software.amazon.awssdk.services.rekognition.model.AssociatedFacesListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociation;
import software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationListCopier;
import software.amazon.awssdk.services.rekognition.model.UserStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateFacesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, AssociateFacesResponse> {
    private static final SdkField<List<AssociatedFace>> ASSOCIATED_FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedFaces").getter(AssociateFacesResponse.getter(AssociateFacesResponse::associatedFaces)).setter(AssociateFacesResponse.setter(Builder::associatedFaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedFaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedFace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnsuccessfulFaceAssociation>> UNSUCCESSFUL_FACE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnsuccessfulFaceAssociations").getter(AssociateFacesResponse.getter(AssociateFacesResponse::unsuccessfulFaceAssociations)).setter(AssociateFacesResponse.setter(Builder::unsuccessfulFaceAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsuccessfulFaceAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnsuccessfulFaceAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserStatus").getter(AssociateFacesResponse.getter(AssociateFacesResponse::userStatusAsString)).setter(AssociateFacesResponse.setter(Builder::userStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_FACES_FIELD, UNSUCCESSFUL_FACE_ASSOCIATIONS_FIELD, USER_STATUS_FIELD));
    private final List<AssociatedFace> associatedFaces;
    private final List<UnsuccessfulFaceAssociation> unsuccessfulFaceAssociations;
    private final String userStatus;

    private AssociateFacesResponse(BuilderImpl builder) {
        super(builder);
        this.associatedFaces = builder.associatedFaces;
        this.unsuccessfulFaceAssociations = builder.unsuccessfulFaceAssociations;
        this.userStatus = builder.userStatus;
    }

    public final boolean hasAssociatedFaces() {
        return this.associatedFaces != null && !(this.associatedFaces instanceof SdkAutoConstructList);
    }

    public final List<AssociatedFace> associatedFaces() {
        return this.associatedFaces;
    }

    public final boolean hasUnsuccessfulFaceAssociations() {
        return this.unsuccessfulFaceAssociations != null && !(this.unsuccessfulFaceAssociations instanceof SdkAutoConstructList);
    }

    public final List<UnsuccessfulFaceAssociation> unsuccessfulFaceAssociations() {
        return this.unsuccessfulFaceAssociations;
    }

    public final UserStatus userStatus() {
        return UserStatus.fromValue(this.userStatus);
    }

    public final String userStatusAsString() {
        return this.userStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedFaces() ? this.associatedFaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnsuccessfulFaceAssociations() ? this.unsuccessfulFaceAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateFacesResponse)) {
            return false;
        }
        AssociateFacesResponse other = (AssociateFacesResponse)((Object)obj);
        return this.hasAssociatedFaces() == other.hasAssociatedFaces() && Objects.equals(this.associatedFaces(), other.associatedFaces()) && this.hasUnsuccessfulFaceAssociations() == other.hasUnsuccessfulFaceAssociations() && Objects.equals(this.unsuccessfulFaceAssociations(), other.unsuccessfulFaceAssociations()) && Objects.equals(this.userStatusAsString(), other.userStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateFacesResponse").add("AssociatedFaces", this.hasAssociatedFaces() ? this.associatedFaces() : null).add("UnsuccessfulFaceAssociations", this.hasUnsuccessfulFaceAssociations() ? this.unsuccessfulFaceAssociations() : null).add("UserStatus", (Object)this.userStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatedFaces": {
                return Optional.ofNullable(clazz.cast(this.associatedFaces()));
            }
            case "UnsuccessfulFaceAssociations": {
                return Optional.ofNullable(clazz.cast(this.unsuccessfulFaceAssociations()));
            }
            case "UserStatus": {
                return Optional.ofNullable(clazz.cast(this.userStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateFacesResponse, T> g) {
        return obj -> g.apply((AssociateFacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<AssociatedFace> associatedFaces = DefaultSdkAutoConstructList.getInstance();
        private List<UnsuccessfulFaceAssociation> unsuccessfulFaceAssociations = DefaultSdkAutoConstructList.getInstance();
        private String userStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateFacesResponse model) {
            super(model);
            this.associatedFaces(model.associatedFaces);
            this.unsuccessfulFaceAssociations(model.unsuccessfulFaceAssociations);
            this.userStatus(model.userStatus);
        }

        public final List<AssociatedFace.Builder> getAssociatedFaces() {
            List<AssociatedFace.Builder> result = AssociatedFacesListCopier.copyToBuilder(this.associatedFaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedFaces(Collection<AssociatedFace.BuilderImpl> associatedFaces) {
            this.associatedFaces = AssociatedFacesListCopier.copyFromBuilder(associatedFaces);
        }

        @Override
        public final Builder associatedFaces(Collection<AssociatedFace> associatedFaces) {
            this.associatedFaces = AssociatedFacesListCopier.copy(associatedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedFaces(AssociatedFace ... associatedFaces) {
            this.associatedFaces(Arrays.asList(associatedFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedFaces(Consumer<AssociatedFace.Builder> ... associatedFaces) {
            this.associatedFaces(Stream.of(associatedFaces).map(c -> (AssociatedFace)((AssociatedFace.Builder)AssociatedFace.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnsuccessfulFaceAssociation.Builder> getUnsuccessfulFaceAssociations() {
            List<UnsuccessfulFaceAssociation.Builder> result = UnsuccessfulFaceAssociationListCopier.copyToBuilder(this.unsuccessfulFaceAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessfulFaceAssociations(Collection<UnsuccessfulFaceAssociation.BuilderImpl> unsuccessfulFaceAssociations) {
            this.unsuccessfulFaceAssociations = UnsuccessfulFaceAssociationListCopier.copyFromBuilder(unsuccessfulFaceAssociations);
        }

        @Override
        public final Builder unsuccessfulFaceAssociations(Collection<UnsuccessfulFaceAssociation> unsuccessfulFaceAssociations) {
            this.unsuccessfulFaceAssociations = UnsuccessfulFaceAssociationListCopier.copy(unsuccessfulFaceAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFaceAssociations(UnsuccessfulFaceAssociation ... unsuccessfulFaceAssociations) {
            this.unsuccessfulFaceAssociations(Arrays.asList(unsuccessfulFaceAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFaceAssociations(Consumer<UnsuccessfulFaceAssociation.Builder> ... unsuccessfulFaceAssociations) {
            this.unsuccessfulFaceAssociations(Stream.of(unsuccessfulFaceAssociations).map(c -> (UnsuccessfulFaceAssociation)((UnsuccessfulFaceAssociation.Builder)UnsuccessfulFaceAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserStatus() {
            return this.userStatus;
        }

        public final void setUserStatus(String userStatus) {
            this.userStatus = userStatus;
        }

        @Override
        public final Builder userStatus(String userStatus) {
            this.userStatus = userStatus;
            return this;
        }

        @Override
        public final Builder userStatus(UserStatus userStatus) {
            this.userStatus(userStatus == null ? null : userStatus.toString());
            return this;
        }

        @Override
        public AssociateFacesResponse build() {
            return new AssociateFacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateFacesResponse> {
        public Builder associatedFaces(Collection<AssociatedFace> var1);

        public Builder associatedFaces(AssociatedFace ... var1);

        public Builder associatedFaces(Consumer<AssociatedFace.Builder> ... var1);

        public Builder unsuccessfulFaceAssociations(Collection<UnsuccessfulFaceAssociation> var1);

        public Builder unsuccessfulFaceAssociations(UnsuccessfulFaceAssociation ... var1);

        public Builder unsuccessfulFaceAssociations(Consumer<UnsuccessfulFaceAssociation.Builder> ... var1);

        public Builder userStatus(String var1);

        public Builder userStatus(UserStatus var1);
    }
}

