/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows you to opt in or opt out to share data with Rekognition to improve model performance. You can choose this
 * option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is
 * ignored on individual streams.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamProcessorDataSharingPreference implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamProcessorDataSharingPreference.Builder, StreamProcessorDataSharingPreference> {
    private static final SdkField<Boolean> OPT_IN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("OptIn")
            .getter(getter(StreamProcessorDataSharingPreference::optIn)).setter(setter(Builder::optIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptIn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_IN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean optIn;

    private StreamProcessorDataSharingPreference(BuilderImpl builder) {
        this.optIn = builder.optIn;
    }

    /**
     * <p>
     * If this option is set to true, you choose to share data with Rekognition to improve model performance.
     * </p>
     * 
     * @return If this option is set to true, you choose to share data with Rekognition to improve model performance.
     */
    public final Boolean optIn() {
        return optIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optIn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessorDataSharingPreference)) {
            return false;
        }
        StreamProcessorDataSharingPreference other = (StreamProcessorDataSharingPreference) obj;
        return Objects.equals(optIn(), other.optIn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamProcessorDataSharingPreference").add("OptIn", optIn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptIn":
            return Optional.ofNullable(clazz.cast(optIn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamProcessorDataSharingPreference, T> g) {
        return obj -> g.apply((StreamProcessorDataSharingPreference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamProcessorDataSharingPreference> {
        /**
         * <p>
         * If this option is set to true, you choose to share data with Rekognition to improve model performance.
         * </p>
         * 
         * @param optIn
         *        If this option is set to true, you choose to share data with Rekognition to improve model performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optIn(Boolean optIn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean optIn;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessorDataSharingPreference model) {
            optIn(model.optIn);
        }

        public final Boolean getOptIn() {
            return optIn;
        }

        public final void setOptIn(Boolean optIn) {
            this.optIn = optIn;
        }

        @Override
        public final Builder optIn(Boolean optIn) {
            this.optIn = optIn;
            return this;
        }

        @Override
        public StreamProcessorDataSharingPreference build() {
            return new StreamProcessorDataSharingPreference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
