/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Face
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Face> {
    private static final SdkField<String> FACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FaceId").getter(Face.getter(Face::faceId)).setter(Face.setter(Builder::faceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceId").build()}).build();
    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BoundingBox").getter(Face.getter(Face::boundingBox)).setter(Face.setter(Builder::boundingBox)).constructor(BoundingBox::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(Face.getter(Face::imageId)).setter(Face.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<String> EXTERNAL_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalImageId").getter(Face.getter(Face::externalImageId)).setter(Face.setter(Builder::externalImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalImageId").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(Face.getter(Face::confidence)).setter(Face.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<String> INDEX_FACES_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexFacesModelVersion").getter(Face.getter(Face::indexFacesModelVersion)).setter(Face.setter(Builder::indexFacesModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexFacesModelVersion").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(Face.getter(Face::userId)).setter(Face.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_ID_FIELD, BOUNDING_BOX_FIELD, IMAGE_ID_FIELD, EXTERNAL_IMAGE_ID_FIELD, CONFIDENCE_FIELD, INDEX_FACES_MODEL_VERSION_FIELD, USER_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String faceId;
    private final BoundingBox boundingBox;
    private final String imageId;
    private final String externalImageId;
    private final Float confidence;
    private final String indexFacesModelVersion;
    private final String userId;

    private Face(BuilderImpl builder) {
        this.faceId = builder.faceId;
        this.boundingBox = builder.boundingBox;
        this.imageId = builder.imageId;
        this.externalImageId = builder.externalImageId;
        this.confidence = builder.confidence;
        this.indexFacesModelVersion = builder.indexFacesModelVersion;
        this.userId = builder.userId;
    }

    public final String faceId() {
        return this.faceId;
    }

    public final BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String externalImageId() {
        return this.externalImageId;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public final String indexFacesModelVersion() {
        return this.indexFacesModelVersion;
    }

    public final String userId() {
        return this.userId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.faceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexFacesModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Face)) {
            return false;
        }
        Face other = (Face)obj;
        return Objects.equals(this.faceId(), other.faceId()) && Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.externalImageId(), other.externalImageId()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.indexFacesModelVersion(), other.indexFacesModelVersion()) && Objects.equals(this.userId(), other.userId());
    }

    public final String toString() {
        return ToString.builder((String)"Face").add("FaceId", (Object)this.faceId()).add("BoundingBox", (Object)this.boundingBox()).add("ImageId", (Object)this.imageId()).add("ExternalImageId", (Object)this.externalImageId()).add("Confidence", (Object)this.confidence()).add("IndexFacesModelVersion", (Object)this.indexFacesModelVersion()).add("UserId", (Object)this.userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FaceId": {
                return Optional.ofNullable(clazz.cast(this.faceId()));
            }
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "ExternalImageId": {
                return Optional.ofNullable(clazz.cast(this.externalImageId()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "IndexFacesModelVersion": {
                return Optional.ofNullable(clazz.cast(this.indexFacesModelVersion()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Face, T> g) {
        return obj -> g.apply((Face)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String faceId;
        private BoundingBox boundingBox;
        private String imageId;
        private String externalImageId;
        private Float confidence;
        private String indexFacesModelVersion;
        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(Face model) {
            this.faceId(model.faceId);
            this.boundingBox(model.boundingBox);
            this.imageId(model.imageId);
            this.externalImageId(model.externalImageId);
            this.confidence(model.confidence);
            this.indexFacesModelVersion(model.indexFacesModelVersion);
            this.userId(model.userId);
        }

        public final String getFaceId() {
            return this.faceId;
        }

        public final void setFaceId(String faceId) {
            this.faceId = faceId;
        }

        @Override
        public final Builder faceId(String faceId) {
            this.faceId = faceId;
            return this;
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getExternalImageId() {
            return this.externalImageId;
        }

        public final void setExternalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
        }

        @Override
        public final Builder externalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
            return this;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final String getIndexFacesModelVersion() {
            return this.indexFacesModelVersion;
        }

        public final void setIndexFacesModelVersion(String indexFacesModelVersion) {
            this.indexFacesModelVersion = indexFacesModelVersion;
        }

        @Override
        public final Builder indexFacesModelVersion(String indexFacesModelVersion) {
            this.indexFacesModelVersion = indexFacesModelVersion;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Face build() {
            return new Face(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Face> {
        public Builder faceId(String var1);

        public Builder boundingBox(BoundingBox var1);

        default public Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return this.boundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(boundingBox)).build());
        }

        public Builder imageId(String var1);

        public Builder externalImageId(String var1);

        public Builder confidence(Float var1);

        public Builder indexFacesModelVersion(String var1);

        public Builder userId(String var1);
    }
}

