/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProjectPoliciesResponse extends RekognitionResponse implements
        ToCopyableBuilder<ListProjectPoliciesResponse.Builder, ListProjectPoliciesResponse> {
    private static final SdkField<List<ProjectPolicy>> PROJECT_POLICIES_FIELD = SdkField
            .<List<ProjectPolicy>> builder(MarshallingType.LIST)
            .memberName("ProjectPolicies")
            .getter(getter(ListProjectPoliciesResponse::projectPolicies))
            .setter(setter(Builder::projectPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListProjectPoliciesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_POLICIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ProjectPolicy> projectPolicies;

    private final String nextToken;

    private ListProjectPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.projectPolicies = builder.projectPolicies;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProjectPolicies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProjectPolicies() {
        return projectPolicies != null && !(projectPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of project policies attached to the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProjectPolicies} method.
     * </p>
     * 
     * @return A list of project policies attached to the project.
     */
    public final List<ProjectPolicy> projectPolicies() {
        return projectPolicies;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent request to
     * retrieve the next set of project policies.
     * </p>
     * 
     * @return If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent
     *         request to retrieve the next set of project policies.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProjectPolicies() ? projectPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectPoliciesResponse)) {
            return false;
        }
        ListProjectPoliciesResponse other = (ListProjectPoliciesResponse) obj;
        return hasProjectPolicies() == other.hasProjectPolicies() && Objects.equals(projectPolicies(), other.projectPolicies())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProjectPoliciesResponse")
                .add("ProjectPolicies", hasProjectPolicies() ? projectPolicies() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectPolicies":
            return Optional.ofNullable(clazz.cast(projectPolicies()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProjectPoliciesResponse, T> g) {
        return obj -> g.apply((ListProjectPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProjectPoliciesResponse> {
        /**
         * <p>
         * A list of project policies attached to the project.
         * </p>
         * 
         * @param projectPolicies
         *        A list of project policies attached to the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectPolicies(Collection<ProjectPolicy> projectPolicies);

        /**
         * <p>
         * A list of project policies attached to the project.
         * </p>
         * 
         * @param projectPolicies
         *        A list of project policies attached to the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectPolicies(ProjectPolicy... projectPolicies);

        /**
         * <p>
         * A list of project policies attached to the project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.ProjectPolicy.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rekognition.model.ProjectPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.ProjectPolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #projectPolicies(List<ProjectPolicy>)}.
         * 
         * @param projectPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.ProjectPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectPolicies(java.util.Collection<ProjectPolicy>)
         */
        Builder projectPolicies(Consumer<ProjectPolicy.Builder>... projectPolicies);

        /**
         * <p>
         * If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent
         * request to retrieve the next set of project policies.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent
         *        request to retrieve the next set of project policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<ProjectPolicy> projectPolicies = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProjectPoliciesResponse model) {
            super(model);
            projectPolicies(model.projectPolicies);
            nextToken(model.nextToken);
        }

        public final List<ProjectPolicy.Builder> getProjectPolicies() {
            List<ProjectPolicy.Builder> result = ProjectPoliciesCopier.copyToBuilder(this.projectPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectPolicies(Collection<ProjectPolicy.BuilderImpl> projectPolicies) {
            this.projectPolicies = ProjectPoliciesCopier.copyFromBuilder(projectPolicies);
        }

        @Override
        public final Builder projectPolicies(Collection<ProjectPolicy> projectPolicies) {
            this.projectPolicies = ProjectPoliciesCopier.copy(projectPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectPolicies(ProjectPolicy... projectPolicies) {
            projectPolicies(Arrays.asList(projectPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectPolicies(Consumer<ProjectPolicy.Builder>... projectPolicies) {
            projectPolicies(Stream.of(projectPolicies).map(c -> ProjectPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProjectPoliciesResponse build() {
            return new ListProjectPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
