/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse;

public class GetCelebrityRecognitionPublisher
implements SdkPublisher<GetCelebrityRecognitionResponse> {
    private final RekognitionAsyncClient client;
    private final GetCelebrityRecognitionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCelebrityRecognitionPublisher(RekognitionAsyncClient client, GetCelebrityRecognitionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCelebrityRecognitionPublisher(RekognitionAsyncClient client, GetCelebrityRecognitionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCelebrityRecognitionResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCelebrityRecognitionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final GetCelebrityRecognitionPublisher resume(GetCelebrityRecognitionResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetCelebrityRecognitionPublisher(this.client, (GetCelebrityRecognitionRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetCelebrityRecognitionPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetCelebrityRecognitionResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetCelebrityRecognitionResponseFetcher
    implements AsyncPageFetcher<GetCelebrityRecognitionResponse> {
        private GetCelebrityRecognitionResponseFetcher() {
        }

        public boolean hasNextPage(GetCelebrityRecognitionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCelebrityRecognitionResponse> nextPage(GetCelebrityRecognitionResponse previousPage) {
            if (previousPage == null) {
                return GetCelebrityRecognitionPublisher.this.client.getCelebrityRecognition(GetCelebrityRecognitionPublisher.this.firstRequest);
            }
            return GetCelebrityRecognitionPublisher.this.client.getCelebrityRecognition((GetCelebrityRecognitionRequest)((Object)GetCelebrityRecognitionPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

