/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesRequest;
import software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesResponse;
import software.amazon.awssdk.services.rekognition.model.ProjectPolicy;

public class ListProjectPoliciesIterable
implements SdkIterable<ListProjectPoliciesResponse> {
    private final RekognitionClient client;
    private final ListProjectPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProjectPoliciesIterable(RekognitionClient client, ListProjectPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProjectPoliciesResponseFetcher();
    }

    public Iterator<ListProjectPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProjectPolicy> projectPolicies() {
        Function<ListProjectPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.projectPolicies() != null) {
                return response.projectPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProjectPoliciesResponseFetcher
    implements SyncPageFetcher<ListProjectPoliciesResponse> {
        private ListProjectPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListProjectPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProjectPoliciesResponse nextPage(ListProjectPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListProjectPoliciesIterable.this.client.listProjectPolicies(ListProjectPoliciesIterable.this.firstRequest);
            }
            return ListProjectPoliciesIterable.this.client.listProjectPolicies((ListProjectPoliciesRequest)((Object)ListProjectPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

