/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionResponse;

public class GetSegmentDetectionIterable
implements SdkIterable<GetSegmentDetectionResponse> {
    private final RekognitionClient client;
    private final GetSegmentDetectionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSegmentDetectionIterable(RekognitionClient client, GetSegmentDetectionRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetSegmentDetectionResponseFetcher();
    }

    public Iterator<GetSegmentDetectionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetSegmentDetectionResponseFetcher
    implements SyncPageFetcher<GetSegmentDetectionResponse> {
        private GetSegmentDetectionResponseFetcher() {
        }

        public boolean hasNextPage(GetSegmentDetectionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetSegmentDetectionResponse nextPage(GetSegmentDetectionResponse previousPage) {
            if (previousPage == null) {
                return GetSegmentDetectionIterable.this.client.getSegmentDetection(GetSegmentDetectionIterable.this.firstRequest);
            }
            return GetSegmentDetectionIterable.this.client.getSegmentDetection((GetSegmentDetectionRequest)((Object)GetSegmentDetectionIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

