/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.model.DatasetLabelDescription;
import software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsResponse;

public class ListDatasetLabelsPublisher
implements SdkPublisher<ListDatasetLabelsResponse> {
    private final RekognitionAsyncClient client;
    private final ListDatasetLabelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDatasetLabelsPublisher(RekognitionAsyncClient client, ListDatasetLabelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDatasetLabelsPublisher(RekognitionAsyncClient client, ListDatasetLabelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDatasetLabelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDatasetLabelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DatasetLabelDescription> datasetLabelDescriptions() {
        Function<ListDatasetLabelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasetLabelDescriptions() != null) {
                return response.datasetLabelDescriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDatasetLabelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDatasetLabelsResponseFetcher
    implements AsyncPageFetcher<ListDatasetLabelsResponse> {
        private ListDatasetLabelsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetLabelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDatasetLabelsResponse> nextPage(ListDatasetLabelsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetLabelsPublisher.this.client.listDatasetLabels(ListDatasetLabelsPublisher.this.firstRequest);
            }
            return ListDatasetLabelsPublisher.this.client.listDatasetLabels((ListDatasetLabelsRequest)((Object)ListDatasetLabelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

