/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.SegmentType;
import software.amazon.awssdk.services.rekognition.model.ShotSegment;
import software.amazon.awssdk.services.rekognition.model.TechnicalCueSegment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentDetection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SegmentDetection> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SegmentDetection.getter(SegmentDetection::typeAsString)).setter(SegmentDetection.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Long> START_TIMESTAMP_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("StartTimestampMillis").getter(SegmentDetection.getter(SegmentDetection::startTimestampMillis)).setter(SegmentDetection.setter(Builder::startTimestampMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestampMillis").build()}).build();
    private static final SdkField<Long> END_TIMESTAMP_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EndTimestampMillis").getter(SegmentDetection.getter(SegmentDetection::endTimestampMillis)).setter(SegmentDetection.setter(Builder::endTimestampMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestampMillis").build()}).build();
    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationMillis").getter(SegmentDetection.getter(SegmentDetection::durationMillis)).setter(SegmentDetection.setter(Builder::durationMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()}).build();
    private static final SdkField<String> START_TIMECODE_SMPTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTimecodeSMPTE").getter(SegmentDetection.getter(SegmentDetection::startTimecodeSMPTE)).setter(SegmentDetection.setter(Builder::startTimecodeSMPTE)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimecodeSMPTE").build()}).build();
    private static final SdkField<String> END_TIMECODE_SMPTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndTimecodeSMPTE").getter(SegmentDetection.getter(SegmentDetection::endTimecodeSMPTE)).setter(SegmentDetection.setter(Builder::endTimecodeSMPTE)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimecodeSMPTE").build()}).build();
    private static final SdkField<String> DURATION_SMPTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurationSMPTE").getter(SegmentDetection.getter(SegmentDetection::durationSMPTE)).setter(SegmentDetection.setter(Builder::durationSMPTE)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSMPTE").build()}).build();
    private static final SdkField<TechnicalCueSegment> TECHNICAL_CUE_SEGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TechnicalCueSegment").getter(SegmentDetection.getter(SegmentDetection::technicalCueSegment)).setter(SegmentDetection.setter(Builder::technicalCueSegment)).constructor(TechnicalCueSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechnicalCueSegment").build()}).build();
    private static final SdkField<ShotSegment> SHOT_SEGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShotSegment").getter(SegmentDetection.getter(SegmentDetection::shotSegment)).setter(SegmentDetection.setter(Builder::shotSegment)).constructor(ShotSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShotSegment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, START_TIMESTAMP_MILLIS_FIELD, END_TIMESTAMP_MILLIS_FIELD, DURATION_MILLIS_FIELD, START_TIMECODE_SMPTE_FIELD, END_TIMECODE_SMPTE_FIELD, DURATION_SMPTE_FIELD, TECHNICAL_CUE_SEGMENT_FIELD, SHOT_SEGMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Long startTimestampMillis;
    private final Long endTimestampMillis;
    private final Long durationMillis;
    private final String startTimecodeSMPTE;
    private final String endTimecodeSMPTE;
    private final String durationSMPTE;
    private final TechnicalCueSegment technicalCueSegment;
    private final ShotSegment shotSegment;

    private SegmentDetection(BuilderImpl builder) {
        this.type = builder.type;
        this.startTimestampMillis = builder.startTimestampMillis;
        this.endTimestampMillis = builder.endTimestampMillis;
        this.durationMillis = builder.durationMillis;
        this.startTimecodeSMPTE = builder.startTimecodeSMPTE;
        this.endTimecodeSMPTE = builder.endTimecodeSMPTE;
        this.durationSMPTE = builder.durationSMPTE;
        this.technicalCueSegment = builder.technicalCueSegment;
        this.shotSegment = builder.shotSegment;
    }

    public final SegmentType type() {
        return SegmentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Long startTimestampMillis() {
        return this.startTimestampMillis;
    }

    public final Long endTimestampMillis() {
        return this.endTimestampMillis;
    }

    public final Long durationMillis() {
        return this.durationMillis;
    }

    public final String startTimecodeSMPTE() {
        return this.startTimecodeSMPTE;
    }

    public final String endTimecodeSMPTE() {
        return this.endTimecodeSMPTE;
    }

    public final String durationSMPTE() {
        return this.durationSMPTE;
    }

    public final TechnicalCueSegment technicalCueSegment() {
        return this.technicalCueSegment;
    }

    public final ShotSegment shotSegment() {
        return this.shotSegment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestampMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestampMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimecodeSMPTE());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimecodeSMPTE());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSMPTE());
        hashCode = 31 * hashCode + Objects.hashCode(this.technicalCueSegment());
        hashCode = 31 * hashCode + Objects.hashCode(this.shotSegment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentDetection)) {
            return false;
        }
        SegmentDetection other = (SegmentDetection)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.startTimestampMillis(), other.startTimestampMillis()) && Objects.equals(this.endTimestampMillis(), other.endTimestampMillis()) && Objects.equals(this.durationMillis(), other.durationMillis()) && Objects.equals(this.startTimecodeSMPTE(), other.startTimecodeSMPTE()) && Objects.equals(this.endTimecodeSMPTE(), other.endTimecodeSMPTE()) && Objects.equals(this.durationSMPTE(), other.durationSMPTE()) && Objects.equals(this.technicalCueSegment(), other.technicalCueSegment()) && Objects.equals(this.shotSegment(), other.shotSegment());
    }

    public final String toString() {
        return ToString.builder((String)"SegmentDetection").add("Type", (Object)this.typeAsString()).add("StartTimestampMillis", (Object)this.startTimestampMillis()).add("EndTimestampMillis", (Object)this.endTimestampMillis()).add("DurationMillis", (Object)this.durationMillis()).add("StartTimecodeSMPTE", (Object)this.startTimecodeSMPTE()).add("EndTimecodeSMPTE", (Object)this.endTimecodeSMPTE()).add("DurationSMPTE", (Object)this.durationSMPTE()).add("TechnicalCueSegment", (Object)this.technicalCueSegment()).add("ShotSegment", (Object)this.shotSegment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "StartTimestampMillis": {
                return Optional.ofNullable(clazz.cast(this.startTimestampMillis()));
            }
            case "EndTimestampMillis": {
                return Optional.ofNullable(clazz.cast(this.endTimestampMillis()));
            }
            case "DurationMillis": {
                return Optional.ofNullable(clazz.cast(this.durationMillis()));
            }
            case "StartTimecodeSMPTE": {
                return Optional.ofNullable(clazz.cast(this.startTimecodeSMPTE()));
            }
            case "EndTimecodeSMPTE": {
                return Optional.ofNullable(clazz.cast(this.endTimecodeSMPTE()));
            }
            case "DurationSMPTE": {
                return Optional.ofNullable(clazz.cast(this.durationSMPTE()));
            }
            case "TechnicalCueSegment": {
                return Optional.ofNullable(clazz.cast(this.technicalCueSegment()));
            }
            case "ShotSegment": {
                return Optional.ofNullable(clazz.cast(this.shotSegment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentDetection, T> g) {
        return obj -> g.apply((SegmentDetection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Long startTimestampMillis;
        private Long endTimestampMillis;
        private Long durationMillis;
        private String startTimecodeSMPTE;
        private String endTimecodeSMPTE;
        private String durationSMPTE;
        private TechnicalCueSegment technicalCueSegment;
        private ShotSegment shotSegment;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentDetection model) {
            this.type(model.type);
            this.startTimestampMillis(model.startTimestampMillis);
            this.endTimestampMillis(model.endTimestampMillis);
            this.durationMillis(model.durationMillis);
            this.startTimecodeSMPTE(model.startTimecodeSMPTE);
            this.endTimecodeSMPTE(model.endTimecodeSMPTE);
            this.durationSMPTE(model.durationSMPTE);
            this.technicalCueSegment(model.technicalCueSegment);
            this.shotSegment(model.shotSegment);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(SegmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Long getStartTimestampMillis() {
            return this.startTimestampMillis;
        }

        public final void setStartTimestampMillis(Long startTimestampMillis) {
            this.startTimestampMillis = startTimestampMillis;
        }

        @Override
        @Transient
        public final Builder startTimestampMillis(Long startTimestampMillis) {
            this.startTimestampMillis = startTimestampMillis;
            return this;
        }

        public final Long getEndTimestampMillis() {
            return this.endTimestampMillis;
        }

        public final void setEndTimestampMillis(Long endTimestampMillis) {
            this.endTimestampMillis = endTimestampMillis;
        }

        @Override
        @Transient
        public final Builder endTimestampMillis(Long endTimestampMillis) {
            this.endTimestampMillis = endTimestampMillis;
            return this;
        }

        public final Long getDurationMillis() {
            return this.durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        @Transient
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final String getStartTimecodeSMPTE() {
            return this.startTimecodeSMPTE;
        }

        public final void setStartTimecodeSMPTE(String startTimecodeSMPTE) {
            this.startTimecodeSMPTE = startTimecodeSMPTE;
        }

        @Override
        @Transient
        public final Builder startTimecodeSMPTE(String startTimecodeSMPTE) {
            this.startTimecodeSMPTE = startTimecodeSMPTE;
            return this;
        }

        public final String getEndTimecodeSMPTE() {
            return this.endTimecodeSMPTE;
        }

        public final void setEndTimecodeSMPTE(String endTimecodeSMPTE) {
            this.endTimecodeSMPTE = endTimecodeSMPTE;
        }

        @Override
        @Transient
        public final Builder endTimecodeSMPTE(String endTimecodeSMPTE) {
            this.endTimecodeSMPTE = endTimecodeSMPTE;
            return this;
        }

        public final String getDurationSMPTE() {
            return this.durationSMPTE;
        }

        public final void setDurationSMPTE(String durationSMPTE) {
            this.durationSMPTE = durationSMPTE;
        }

        @Override
        @Transient
        public final Builder durationSMPTE(String durationSMPTE) {
            this.durationSMPTE = durationSMPTE;
            return this;
        }

        public final TechnicalCueSegment.Builder getTechnicalCueSegment() {
            return this.technicalCueSegment != null ? this.technicalCueSegment.toBuilder() : null;
        }

        public final void setTechnicalCueSegment(TechnicalCueSegment.BuilderImpl technicalCueSegment) {
            this.technicalCueSegment = technicalCueSegment != null ? technicalCueSegment.build() : null;
        }

        @Override
        @Transient
        public final Builder technicalCueSegment(TechnicalCueSegment technicalCueSegment) {
            this.technicalCueSegment = technicalCueSegment;
            return this;
        }

        public final ShotSegment.Builder getShotSegment() {
            return this.shotSegment != null ? this.shotSegment.toBuilder() : null;
        }

        public final void setShotSegment(ShotSegment.BuilderImpl shotSegment) {
            this.shotSegment = shotSegment != null ? shotSegment.build() : null;
        }

        @Override
        @Transient
        public final Builder shotSegment(ShotSegment shotSegment) {
            this.shotSegment = shotSegment;
            return this;
        }

        public SegmentDetection build() {
            return new SegmentDetection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SegmentDetection> {
        public Builder type(String var1);

        public Builder type(SegmentType var1);

        public Builder startTimestampMillis(Long var1);

        public Builder endTimestampMillis(Long var1);

        public Builder durationMillis(Long var1);

        public Builder startTimecodeSMPTE(String var1);

        public Builder endTimecodeSMPTE(String var1);

        public Builder durationSMPTE(String var1);

        public Builder technicalCueSegment(TechnicalCueSegment var1);

        default public Builder technicalCueSegment(Consumer<TechnicalCueSegment.Builder> technicalCueSegment) {
            return this.technicalCueSegment((TechnicalCueSegment)((TechnicalCueSegment.Builder)TechnicalCueSegment.builder().applyMutation(technicalCueSegment)).build());
        }

        public Builder shotSegment(ShotSegment var1);

        default public Builder shotSegment(Consumer<ShotSegment.Builder> shotSegment) {
            return this.shotSegment((ShotSegment)((ShotSegment.Builder)ShotSegment.builder().applyMutation(shotSegment)).build());
        }
    }
}

