/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.TextDetectionResult;
import software.amazon.awssdk.services.rekognition.model.TextDetectionResultsCopier;
import software.amazon.awssdk.services.rekognition.model.VideoJobStatus;
import software.amazon.awssdk.services.rekognition.model.VideoMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTextDetectionResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, GetTextDetectionResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(GetTextDetectionResponse.getter(GetTextDetectionResponse::jobStatusAsString)).setter(GetTextDetectionResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetTextDetectionResponse.getter(GetTextDetectionResponse::statusMessage)).setter(GetTextDetectionResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<VideoMetadata> VIDEO_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VideoMetadata").getter(GetTextDetectionResponse.getter(GetTextDetectionResponse::videoMetadata)).setter(GetTextDetectionResponse.setter(Builder::videoMetadata)).constructor(VideoMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoMetadata").build()}).build();
    private static final SdkField<List<TextDetectionResult>> TEXT_DETECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TextDetections").getter(GetTextDetectionResponse.getter(GetTextDetectionResponse::textDetections)).setter(GetTextDetectionResponse.setter(Builder::textDetections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextDetections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TextDetectionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTextDetectionResponse.getter(GetTextDetectionResponse::nextToken)).setter(GetTextDetectionResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> TEXT_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextModelVersion").getter(GetTextDetectionResponse.getter(GetTextDetectionResponse::textModelVersion)).setter(GetTextDetectionResponse.setter(Builder::textModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, STATUS_MESSAGE_FIELD, VIDEO_METADATA_FIELD, TEXT_DETECTIONS_FIELD, NEXT_TOKEN_FIELD, TEXT_MODEL_VERSION_FIELD));
    private final String jobStatus;
    private final String statusMessage;
    private final VideoMetadata videoMetadata;
    private final List<TextDetectionResult> textDetections;
    private final String nextToken;
    private final String textModelVersion;

    private GetTextDetectionResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.videoMetadata = builder.videoMetadata;
        this.textDetections = builder.textDetections;
        this.nextToken = builder.nextToken;
        this.textModelVersion = builder.textModelVersion;
    }

    public final VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final VideoMetadata videoMetadata() {
        return this.videoMetadata;
    }

    public final boolean hasTextDetections() {
        return this.textDetections != null && !(this.textDetections instanceof SdkAutoConstructList);
    }

    public final List<TextDetectionResult> textDetections() {
        return this.textDetections;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String textModelVersion() {
        return this.textModelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextDetections() ? this.textDetections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.textModelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTextDetectionResponse)) {
            return false;
        }
        GetTextDetectionResponse other = (GetTextDetectionResponse)((Object)obj);
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.videoMetadata(), other.videoMetadata()) && this.hasTextDetections() == other.hasTextDetections() && Objects.equals(this.textDetections(), other.textDetections()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.textModelVersion(), other.textModelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetTextDetectionResponse").add("JobStatus", (Object)this.jobStatusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("VideoMetadata", (Object)this.videoMetadata()).add("TextDetections", this.hasTextDetections() ? this.textDetections() : null).add("NextToken", (Object)this.nextToken()).add("TextModelVersion", (Object)this.textModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "VideoMetadata": {
                return Optional.ofNullable(clazz.cast(this.videoMetadata()));
            }
            case "TextDetections": {
                return Optional.ofNullable(clazz.cast(this.textDetections()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TextModelVersion": {
                return Optional.ofNullable(clazz.cast(this.textModelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTextDetectionResponse, T> g) {
        return obj -> g.apply((GetTextDetectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String jobStatus;
        private String statusMessage;
        private VideoMetadata videoMetadata;
        private List<TextDetectionResult> textDetections = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String textModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTextDetectionResponse model) {
            super(model);
            this.jobStatus(model.jobStatus);
            this.statusMessage(model.statusMessage);
            this.videoMetadata(model.videoMetadata);
            this.textDetections(model.textDetections);
            this.nextToken(model.nextToken);
            this.textModelVersion(model.textModelVersion);
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final VideoMetadata.Builder getVideoMetadata() {
            return this.videoMetadata != null ? this.videoMetadata.toBuilder() : null;
        }

        @Override
        public final Builder videoMetadata(VideoMetadata videoMetadata) {
            this.videoMetadata = videoMetadata;
            return this;
        }

        public final void setVideoMetadata(VideoMetadata.BuilderImpl videoMetadata) {
            this.videoMetadata = videoMetadata != null ? videoMetadata.build() : null;
        }

        public final Collection<TextDetectionResult.Builder> getTextDetections() {
            if (this.textDetections instanceof SdkAutoConstructList) {
                return null;
            }
            return this.textDetections != null ? (Collection)this.textDetections.stream().map(TextDetectionResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder textDetections(Collection<TextDetectionResult> textDetections) {
            this.textDetections = TextDetectionResultsCopier.copy(textDetections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textDetections(TextDetectionResult ... textDetections) {
            this.textDetections(Arrays.asList(textDetections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textDetections(Consumer<TextDetectionResult.Builder> ... textDetections) {
            this.textDetections(Stream.of(textDetections).map(c -> (TextDetectionResult)((TextDetectionResult.Builder)TextDetectionResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTextDetections(Collection<TextDetectionResult.BuilderImpl> textDetections) {
            this.textDetections = TextDetectionResultsCopier.copyFromBuilder(textDetections);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getTextModelVersion() {
            return this.textModelVersion;
        }

        @Override
        public final Builder textModelVersion(String textModelVersion) {
            this.textModelVersion = textModelVersion;
            return this;
        }

        public final void setTextModelVersion(String textModelVersion) {
            this.textModelVersion = textModelVersion;
        }

        @Override
        public GetTextDetectionResponse build() {
            return new GetTextDetectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTextDetectionResponse> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(VideoJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder videoMetadata(VideoMetadata var1);

        default public Builder videoMetadata(Consumer<VideoMetadata.Builder> videoMetadata) {
            return this.videoMetadata((VideoMetadata)((VideoMetadata.Builder)VideoMetadata.builder().applyMutation(videoMetadata)).build());
        }

        public Builder textDetections(Collection<TextDetectionResult> var1);

        public Builder textDetections(TextDetectionResult ... var1);

        public Builder textDetections(Consumer<TextDetectionResult.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder textModelVersion(String var1);
    }
}

