/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest;
import software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse;

public class GetContentModerationIterable
implements SdkIterable<GetContentModerationResponse> {
    private final RekognitionClient client;
    private final GetContentModerationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetContentModerationIterable(RekognitionClient client, GetContentModerationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetContentModerationResponseFetcher();
    }

    public Iterator<GetContentModerationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetContentModerationResponseFetcher
    implements SyncPageFetcher<GetContentModerationResponse> {
        private GetContentModerationResponseFetcher() {
        }

        public boolean hasNextPage(GetContentModerationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetContentModerationResponse nextPage(GetContentModerationResponse previousPage) {
            if (previousPage == null) {
                return GetContentModerationIterable.this.client.getContentModeration(GetContentModerationIterable.this.firstRequest);
            }
            return GetContentModerationIterable.this.client.getContentModeration((GetContentModerationRequest)((Object)GetContentModerationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

