/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageQuality
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageQuality> {
    private static final SdkField<Float> BRIGHTNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Brightness").getter(ImageQuality.getter(ImageQuality::brightness)).setter(ImageQuality.setter(Builder::brightness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brightness").build()}).build();
    private static final SdkField<Float> SHARPNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Sharpness").getter(ImageQuality.getter(ImageQuality::sharpness)).setter(ImageQuality.setter(Builder::sharpness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sharpness").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIGHTNESS_FIELD, SHARPNESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Float brightness;
    private final Float sharpness;

    private ImageQuality(BuilderImpl builder) {
        this.brightness = builder.brightness;
        this.sharpness = builder.sharpness;
    }

    public Float brightness() {
        return this.brightness;
    }

    public Float sharpness() {
        return this.sharpness;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brightness());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharpness());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageQuality)) {
            return false;
        }
        ImageQuality other = (ImageQuality)obj;
        return Objects.equals(this.brightness(), other.brightness()) && Objects.equals(this.sharpness(), other.sharpness());
    }

    public String toString() {
        return ToString.builder((String)"ImageQuality").add("Brightness", (Object)this.brightness()).add("Sharpness", (Object)this.sharpness()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Brightness": {
                return Optional.ofNullable(clazz.cast(this.brightness()));
            }
            case "Sharpness": {
                return Optional.ofNullable(clazz.cast(this.sharpness()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageQuality, T> g) {
        return obj -> g.apply((ImageQuality)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float brightness;
        private Float sharpness;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageQuality model) {
            this.brightness(model.brightness);
            this.sharpness(model.sharpness);
        }

        public final Float getBrightness() {
            return this.brightness;
        }

        @Override
        public final Builder brightness(Float brightness) {
            this.brightness = brightness;
            return this;
        }

        public final void setBrightness(Float brightness) {
            this.brightness = brightness;
        }

        public final Float getSharpness() {
            return this.sharpness;
        }

        @Override
        public final Builder sharpness(Float sharpness) {
            this.sharpness = sharpness;
            return this;
        }

        public final void setSharpness(Float sharpness) {
            this.sharpness = sharpness;
        }

        public ImageQuality build() {
            return new ImageQuality(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageQuality> {
        public Builder brightness(Float var1);

        public Builder sharpness(Float var1);
    }
}

