/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.TextDetection;
import software.amazon.awssdk.services.rekognition.model.TextDetectionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectTextResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DetectTextResponse> {
    private static final SdkField<List<TextDetection>> TEXT_DETECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TextDetections").getter(DetectTextResponse.getter(DetectTextResponse::textDetections)).setter(DetectTextResponse.setter(Builder::textDetections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextDetections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TextDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEXT_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextModelVersion").getter(DetectTextResponse.getter(DetectTextResponse::textModelVersion)).setter(DetectTextResponse.setter(Builder::textModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_DETECTIONS_FIELD, TEXT_MODEL_VERSION_FIELD));
    private final List<TextDetection> textDetections;
    private final String textModelVersion;

    private DetectTextResponse(BuilderImpl builder) {
        super(builder);
        this.textDetections = builder.textDetections;
        this.textModelVersion = builder.textModelVersion;
    }

    public final boolean hasTextDetections() {
        return this.textDetections != null && !(this.textDetections instanceof SdkAutoConstructList);
    }

    public final List<TextDetection> textDetections() {
        return this.textDetections;
    }

    public final String textModelVersion() {
        return this.textModelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextDetections() ? this.textDetections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.textModelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectTextResponse)) {
            return false;
        }
        DetectTextResponse other = (DetectTextResponse)((Object)obj);
        return this.hasTextDetections() == other.hasTextDetections() && Objects.equals(this.textDetections(), other.textDetections()) && Objects.equals(this.textModelVersion(), other.textModelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DetectTextResponse").add("TextDetections", this.hasTextDetections() ? this.textDetections() : null).add("TextModelVersion", (Object)this.textModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TextDetections": {
                return Optional.ofNullable(clazz.cast(this.textDetections()));
            }
            case "TextModelVersion": {
                return Optional.ofNullable(clazz.cast(this.textModelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectTextResponse, T> g) {
        return obj -> g.apply((DetectTextResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<TextDetection> textDetections = DefaultSdkAutoConstructList.getInstance();
        private String textModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectTextResponse model) {
            super(model);
            this.textDetections(model.textDetections);
            this.textModelVersion(model.textModelVersion);
        }

        public final Collection<TextDetection.Builder> getTextDetections() {
            if (this.textDetections instanceof SdkAutoConstructList) {
                return null;
            }
            return this.textDetections != null ? (Collection)this.textDetections.stream().map(TextDetection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder textDetections(Collection<TextDetection> textDetections) {
            this.textDetections = TextDetectionListCopier.copy(textDetections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textDetections(TextDetection ... textDetections) {
            this.textDetections(Arrays.asList(textDetections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textDetections(Consumer<TextDetection.Builder> ... textDetections) {
            this.textDetections(Stream.of(textDetections).map(c -> (TextDetection)((TextDetection.Builder)TextDetection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTextDetections(Collection<TextDetection.BuilderImpl> textDetections) {
            this.textDetections = TextDetectionListCopier.copyFromBuilder(textDetections);
        }

        public final String getTextModelVersion() {
            return this.textModelVersion;
        }

        @Override
        public final Builder textModelVersion(String textModelVersion) {
            this.textModelVersion = textModelVersion;
            return this;
        }

        public final void setTextModelVersion(String textModelVersion) {
            this.textModelVersion = textModelVersion;
        }

        @Override
        public DetectTextResponse build() {
            return new DetectTextResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectTextResponse> {
        public Builder textDetections(Collection<TextDetection> var1);

        public Builder textDetections(TextDetection ... var1);

        public Builder textDetections(Consumer<TextDetection.Builder> ... var1);

        public Builder textModelVersion(String var1);
    }
}

