/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.HumanLoopActivationReasonsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HumanLoopActivationOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HumanLoopActivationOutput> {
    private static final SdkField<String> HUMAN_LOOP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HumanLoopArn").getter(HumanLoopActivationOutput.getter(HumanLoopActivationOutput::humanLoopArn)).setter(HumanLoopActivationOutput.setter(Builder::humanLoopArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopArn").build()}).build();
    private static final SdkField<List<String>> HUMAN_LOOP_ACTIVATION_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HumanLoopActivationReasons").getter(HumanLoopActivationOutput.getter(HumanLoopActivationOutput::humanLoopActivationReasons)).setter(HumanLoopActivationOutput.setter(Builder::humanLoopActivationReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HUMAN_LOOP_ACTIVATION_CONDITIONS_EVALUATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HumanLoopActivationConditionsEvaluationResults").getter(HumanLoopActivationOutput.getter(HumanLoopActivationOutput::humanLoopActivationConditionsEvaluationResults)).setter(HumanLoopActivationOutput.setter(Builder::humanLoopActivationConditionsEvaluationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationConditionsEvaluationResults").build(), JsonValueTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_LOOP_ARN_FIELD, HUMAN_LOOP_ACTIVATION_REASONS_FIELD, HUMAN_LOOP_ACTIVATION_CONDITIONS_EVALUATION_RESULTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String humanLoopArn;
    private final List<String> humanLoopActivationReasons;
    private final String humanLoopActivationConditionsEvaluationResults;

    private HumanLoopActivationOutput(BuilderImpl builder) {
        this.humanLoopArn = builder.humanLoopArn;
        this.humanLoopActivationReasons = builder.humanLoopActivationReasons;
        this.humanLoopActivationConditionsEvaluationResults = builder.humanLoopActivationConditionsEvaluationResults;
    }

    public final String humanLoopArn() {
        return this.humanLoopArn;
    }

    public final boolean hasHumanLoopActivationReasons() {
        return this.humanLoopActivationReasons != null && !(this.humanLoopActivationReasons instanceof SdkAutoConstructList);
    }

    public final List<String> humanLoopActivationReasons() {
        return this.humanLoopActivationReasons;
    }

    public final String humanLoopActivationConditionsEvaluationResults() {
        return this.humanLoopActivationConditionsEvaluationResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHumanLoopActivationReasons() ? this.humanLoopActivationReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopActivationConditionsEvaluationResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopActivationOutput)) {
            return false;
        }
        HumanLoopActivationOutput other = (HumanLoopActivationOutput)obj;
        return Objects.equals(this.humanLoopArn(), other.humanLoopArn()) && this.hasHumanLoopActivationReasons() == other.hasHumanLoopActivationReasons() && Objects.equals(this.humanLoopActivationReasons(), other.humanLoopActivationReasons()) && Objects.equals(this.humanLoopActivationConditionsEvaluationResults(), other.humanLoopActivationConditionsEvaluationResults());
    }

    public final String toString() {
        return ToString.builder((String)"HumanLoopActivationOutput").add("HumanLoopArn", (Object)this.humanLoopArn()).add("HumanLoopActivationReasons", this.hasHumanLoopActivationReasons() ? this.humanLoopActivationReasons() : null).add("HumanLoopActivationConditionsEvaluationResults", (Object)this.humanLoopActivationConditionsEvaluationResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HumanLoopArn": {
                return Optional.ofNullable(clazz.cast(this.humanLoopArn()));
            }
            case "HumanLoopActivationReasons": {
                return Optional.ofNullable(clazz.cast(this.humanLoopActivationReasons()));
            }
            case "HumanLoopActivationConditionsEvaluationResults": {
                return Optional.ofNullable(clazz.cast(this.humanLoopActivationConditionsEvaluationResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopActivationOutput, T> g) {
        return obj -> g.apply((HumanLoopActivationOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String humanLoopArn;
        private List<String> humanLoopActivationReasons = DefaultSdkAutoConstructList.getInstance();
        private String humanLoopActivationConditionsEvaluationResults;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopActivationOutput model) {
            this.humanLoopArn(model.humanLoopArn);
            this.humanLoopActivationReasons(model.humanLoopActivationReasons);
            this.humanLoopActivationConditionsEvaluationResults(model.humanLoopActivationConditionsEvaluationResults);
        }

        public final String getHumanLoopArn() {
            return this.humanLoopArn;
        }

        @Override
        public final Builder humanLoopArn(String humanLoopArn) {
            this.humanLoopArn = humanLoopArn;
            return this;
        }

        public final void setHumanLoopArn(String humanLoopArn) {
            this.humanLoopArn = humanLoopArn;
        }

        public final Collection<String> getHumanLoopActivationReasons() {
            if (this.humanLoopActivationReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.humanLoopActivationReasons;
        }

        @Override
        public final Builder humanLoopActivationReasons(Collection<String> humanLoopActivationReasons) {
            this.humanLoopActivationReasons = HumanLoopActivationReasonsCopier.copy(humanLoopActivationReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder humanLoopActivationReasons(String ... humanLoopActivationReasons) {
            this.humanLoopActivationReasons(Arrays.asList(humanLoopActivationReasons));
            return this;
        }

        public final void setHumanLoopActivationReasons(Collection<String> humanLoopActivationReasons) {
            this.humanLoopActivationReasons = HumanLoopActivationReasonsCopier.copy(humanLoopActivationReasons);
        }

        public final String getHumanLoopActivationConditionsEvaluationResults() {
            return this.humanLoopActivationConditionsEvaluationResults;
        }

        @Override
        public final Builder humanLoopActivationConditionsEvaluationResults(String humanLoopActivationConditionsEvaluationResults) {
            this.humanLoopActivationConditionsEvaluationResults = humanLoopActivationConditionsEvaluationResults;
            return this;
        }

        public final void setHumanLoopActivationConditionsEvaluationResults(String humanLoopActivationConditionsEvaluationResults) {
            this.humanLoopActivationConditionsEvaluationResults = humanLoopActivationConditionsEvaluationResults;
        }

        public HumanLoopActivationOutput build() {
            return new HumanLoopActivationOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HumanLoopActivationOutput> {
        public Builder humanLoopArn(String var1);

        public Builder humanLoopActivationReasons(Collection<String> var1);

        public Builder humanLoopActivationReasons(String ... var1);

        public Builder humanLoopActivationConditionsEvaluationResults(String var1);
    }
}

