/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ProjectVersionStatus {
    TRAINING_IN_PROGRESS("TRAINING_IN_PROGRESS"),
    TRAINING_COMPLETED("TRAINING_COMPLETED"),
    TRAINING_FAILED("TRAINING_FAILED"),
    STARTING("STARTING"),
    RUNNING("RUNNING"),
    FAILED("FAILED"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ProjectVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProjectVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ProjectVersionStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProjectVersionStatus> knownValues() {
        return Stream.of(ProjectVersionStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

