/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.Geometry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomLabel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomLabel> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CustomLabel.getter(CustomLabel::name)).setter(CustomLabel.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(CustomLabel.getter(CustomLabel::confidence)).setter(CustomLabel.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<Geometry> GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Geometry").getter(CustomLabel.getter(CustomLabel::geometry)).setter(CustomLabel.setter(Builder::geometry)).constructor(Geometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONFIDENCE_FIELD, GEOMETRY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Float confidence;
    private final Geometry geometry;

    private CustomLabel(BuilderImpl builder) {
        this.name = builder.name;
        this.confidence = builder.confidence;
        this.geometry = builder.geometry;
    }

    public String name() {
        return this.name;
    }

    public Float confidence() {
        return this.confidence;
    }

    public Geometry geometry() {
        return this.geometry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometry());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLabel)) {
            return false;
        }
        CustomLabel other = (CustomLabel)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.geometry(), other.geometry());
    }

    public String toString() {
        return ToString.builder((String)"CustomLabel").add("Name", (Object)this.name()).add("Confidence", (Object)this.confidence()).add("Geometry", (Object)this.geometry()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Geometry": {
                return Optional.ofNullable(clazz.cast(this.geometry()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomLabel, T> g) {
        return obj -> g.apply((CustomLabel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Float confidence;
        private Geometry geometry;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLabel model) {
            this.name(model.name);
            this.confidence(model.confidence);
            this.geometry(model.geometry);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public final Geometry.Builder getGeometry() {
            return this.geometry != null ? this.geometry.toBuilder() : null;
        }

        @Override
        public final Builder geometry(Geometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final void setGeometry(Geometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        public CustomLabel build() {
            return new CustomLabel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomLabel> {
        public Builder name(String var1);

        public Builder confidence(Float var1);

        public Builder geometry(Geometry var1);

        default public Builder geometry(Consumer<Geometry.Builder> geometry) {
            return this.geometry((Geometry)((Geometry.Builder)Geometry.builder().applyMutation(geometry)).build());
        }
    }
}

