/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.AudioMetadata;
import software.amazon.awssdk.services.rekognition.model.AudioMetadataListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.SegmentDetection;
import software.amazon.awssdk.services.rekognition.model.SegmentDetectionsCopier;
import software.amazon.awssdk.services.rekognition.model.SegmentTypeInfo;
import software.amazon.awssdk.services.rekognition.model.SegmentTypesInfoCopier;
import software.amazon.awssdk.services.rekognition.model.VideoJobStatus;
import software.amazon.awssdk.services.rekognition.model.VideoMetadata;
import software.amazon.awssdk.services.rekognition.model.VideoMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSegmentDetectionResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, GetSegmentDetectionResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(GetSegmentDetectionResponse.getter(GetSegmentDetectionResponse::jobStatusAsString)).setter(GetSegmentDetectionResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetSegmentDetectionResponse.getter(GetSegmentDetectionResponse::statusMessage)).setter(GetSegmentDetectionResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<List<VideoMetadata>> VIDEO_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VideoMetadata").getter(GetSegmentDetectionResponse.getter(GetSegmentDetectionResponse::videoMetadata)).setter(GetSegmentDetectionResponse.setter(Builder::videoMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VideoMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AudioMetadata>> AUDIO_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AudioMetadata").getter(GetSegmentDetectionResponse.getter(GetSegmentDetectionResponse::audioMetadata)).setter(GetSegmentDetectionResponse.setter(Builder::audioMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetSegmentDetectionResponse.getter(GetSegmentDetectionResponse::nextToken)).setter(GetSegmentDetectionResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<SegmentDetection>> SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Segments").getter(GetSegmentDetectionResponse.getter(GetSegmentDetectionResponse::segments)).setter(GetSegmentDetectionResponse.setter(Builder::segments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SegmentTypeInfo>> SELECTED_SEGMENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedSegmentTypes").getter(GetSegmentDetectionResponse.getter(GetSegmentDetectionResponse::selectedSegmentTypes)).setter(GetSegmentDetectionResponse.setter(Builder::selectedSegmentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedSegmentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentTypeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, STATUS_MESSAGE_FIELD, VIDEO_METADATA_FIELD, AUDIO_METADATA_FIELD, NEXT_TOKEN_FIELD, SEGMENTS_FIELD, SELECTED_SEGMENT_TYPES_FIELD));
    private final String jobStatus;
    private final String statusMessage;
    private final List<VideoMetadata> videoMetadata;
    private final List<AudioMetadata> audioMetadata;
    private final String nextToken;
    private final List<SegmentDetection> segments;
    private final List<SegmentTypeInfo> selectedSegmentTypes;

    private GetSegmentDetectionResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.videoMetadata = builder.videoMetadata;
        this.audioMetadata = builder.audioMetadata;
        this.nextToken = builder.nextToken;
        this.segments = builder.segments;
        this.selectedSegmentTypes = builder.selectedSegmentTypes;
    }

    public VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(this.jobStatus);
    }

    public String jobStatusAsString() {
        return this.jobStatus;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public boolean hasVideoMetadata() {
        return this.videoMetadata != null && !(this.videoMetadata instanceof SdkAutoConstructList);
    }

    public List<VideoMetadata> videoMetadata() {
        return this.videoMetadata;
    }

    public boolean hasAudioMetadata() {
        return this.audioMetadata != null && !(this.audioMetadata instanceof SdkAutoConstructList);
    }

    public List<AudioMetadata> audioMetadata() {
        return this.audioMetadata;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasSegments() {
        return this.segments != null && !(this.segments instanceof SdkAutoConstructList);
    }

    public List<SegmentDetection> segments() {
        return this.segments;
    }

    public boolean hasSelectedSegmentTypes() {
        return this.selectedSegmentTypes != null && !(this.selectedSegmentTypes instanceof SdkAutoConstructList);
    }

    public List<SegmentTypeInfo> selectedSegmentTypes() {
        return this.selectedSegmentTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.segments());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectedSegmentTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentDetectionResponse)) {
            return false;
        }
        GetSegmentDetectionResponse other = (GetSegmentDetectionResponse)((Object)obj);
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.videoMetadata(), other.videoMetadata()) && Objects.equals(this.audioMetadata(), other.audioMetadata()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.segments(), other.segments()) && Objects.equals(this.selectedSegmentTypes(), other.selectedSegmentTypes());
    }

    public String toString() {
        return ToString.builder((String)"GetSegmentDetectionResponse").add("JobStatus", (Object)this.jobStatusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("VideoMetadata", this.videoMetadata()).add("AudioMetadata", this.audioMetadata()).add("NextToken", (Object)this.nextToken()).add("Segments", this.segments()).add("SelectedSegmentTypes", this.selectedSegmentTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "VideoMetadata": {
                return Optional.ofNullable(clazz.cast(this.videoMetadata()));
            }
            case "AudioMetadata": {
                return Optional.ofNullable(clazz.cast(this.audioMetadata()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Segments": {
                return Optional.ofNullable(clazz.cast(this.segments()));
            }
            case "SelectedSegmentTypes": {
                return Optional.ofNullable(clazz.cast(this.selectedSegmentTypes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSegmentDetectionResponse, T> g) {
        return obj -> g.apply((GetSegmentDetectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String jobStatus;
        private String statusMessage;
        private List<VideoMetadata> videoMetadata = DefaultSdkAutoConstructList.getInstance();
        private List<AudioMetadata> audioMetadata = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private List<SegmentDetection> segments = DefaultSdkAutoConstructList.getInstance();
        private List<SegmentTypeInfo> selectedSegmentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentDetectionResponse model) {
            super(model);
            this.jobStatus(model.jobStatus);
            this.statusMessage(model.statusMessage);
            this.videoMetadata(model.videoMetadata);
            this.audioMetadata(model.audioMetadata);
            this.nextToken(model.nextToken);
            this.segments(model.segments);
            this.selectedSegmentTypes(model.selectedSegmentTypes);
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Collection<VideoMetadata.Builder> getVideoMetadata() {
            return this.videoMetadata != null ? (Collection)this.videoMetadata.stream().map(VideoMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder videoMetadata(Collection<VideoMetadata> videoMetadata) {
            this.videoMetadata = VideoMetadataListCopier.copy(videoMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoMetadata(VideoMetadata ... videoMetadata) {
            this.videoMetadata(Arrays.asList(videoMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoMetadata(Consumer<VideoMetadata.Builder> ... videoMetadata) {
            this.videoMetadata(Stream.of(videoMetadata).map(c -> (VideoMetadata)((VideoMetadata.Builder)VideoMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVideoMetadata(Collection<VideoMetadata.BuilderImpl> videoMetadata) {
            this.videoMetadata = VideoMetadataListCopier.copyFromBuilder(videoMetadata);
        }

        public final Collection<AudioMetadata.Builder> getAudioMetadata() {
            return this.audioMetadata != null ? (Collection)this.audioMetadata.stream().map(AudioMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder audioMetadata(Collection<AudioMetadata> audioMetadata) {
            this.audioMetadata = AudioMetadataListCopier.copy(audioMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioMetadata(AudioMetadata ... audioMetadata) {
            this.audioMetadata(Arrays.asList(audioMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioMetadata(Consumer<AudioMetadata.Builder> ... audioMetadata) {
            this.audioMetadata(Stream.of(audioMetadata).map(c -> (AudioMetadata)((AudioMetadata.Builder)AudioMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAudioMetadata(Collection<AudioMetadata.BuilderImpl> audioMetadata) {
            this.audioMetadata = AudioMetadataListCopier.copyFromBuilder(audioMetadata);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SegmentDetection.Builder> getSegments() {
            return this.segments != null ? (Collection)this.segments.stream().map(SegmentDetection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder segments(Collection<SegmentDetection> segments) {
            this.segments = SegmentDetectionsCopier.copy(segments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(SegmentDetection ... segments) {
            this.segments(Arrays.asList(segments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(Consumer<SegmentDetection.Builder> ... segments) {
            this.segments(Stream.of(segments).map(c -> (SegmentDetection)((SegmentDetection.Builder)SegmentDetection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSegments(Collection<SegmentDetection.BuilderImpl> segments) {
            this.segments = SegmentDetectionsCopier.copyFromBuilder(segments);
        }

        public final Collection<SegmentTypeInfo.Builder> getSelectedSegmentTypes() {
            return this.selectedSegmentTypes != null ? (Collection)this.selectedSegmentTypes.stream().map(SegmentTypeInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder selectedSegmentTypes(Collection<SegmentTypeInfo> selectedSegmentTypes) {
            this.selectedSegmentTypes = SegmentTypesInfoCopier.copy(selectedSegmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedSegmentTypes(SegmentTypeInfo ... selectedSegmentTypes) {
            this.selectedSegmentTypes(Arrays.asList(selectedSegmentTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedSegmentTypes(Consumer<SegmentTypeInfo.Builder> ... selectedSegmentTypes) {
            this.selectedSegmentTypes(Stream.of(selectedSegmentTypes).map(c -> (SegmentTypeInfo)((SegmentTypeInfo.Builder)SegmentTypeInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSelectedSegmentTypes(Collection<SegmentTypeInfo.BuilderImpl> selectedSegmentTypes) {
            this.selectedSegmentTypes = SegmentTypesInfoCopier.copyFromBuilder(selectedSegmentTypes);
        }

        @Override
        public GetSegmentDetectionResponse build() {
            return new GetSegmentDetectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSegmentDetectionResponse> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(VideoJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder videoMetadata(Collection<VideoMetadata> var1);

        public Builder videoMetadata(VideoMetadata ... var1);

        public Builder videoMetadata(Consumer<VideoMetadata.Builder> ... var1);

        public Builder audioMetadata(Collection<AudioMetadata> var1);

        public Builder audioMetadata(AudioMetadata ... var1);

        public Builder audioMetadata(Consumer<AudioMetadata.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder segments(Collection<SegmentDetection> var1);

        public Builder segments(SegmentDetection ... var1);

        public Builder segments(Consumer<SegmentDetection.Builder> ... var1);

        public Builder selectedSegmentTypes(Collection<SegmentTypeInfo> var1);

        public Builder selectedSegmentTypes(SegmentTypeInfo ... var1);

        public Builder selectedSegmentTypes(Consumer<SegmentTypeInfo.Builder> ... var1);
    }
}

