/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioMetadata> {
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AudioMetadata.getter(AudioMetadata::codec)).setter(AudioMetadata.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Codec").build()}).build();
    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(AudioMetadata.getter(AudioMetadata::durationMillis)).setter(AudioMetadata.setter(Builder::durationMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()}).build();
    private static final SdkField<Long> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(AudioMetadata.getter(AudioMetadata::sampleRate)).setter(AudioMetadata.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleRate").build()}).build();
    private static final SdkField<Long> NUMBER_OF_CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(AudioMetadata.getter(AudioMetadata::numberOfChannels)).setter(AudioMetadata.setter(Builder::numberOfChannels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfChannels").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEC_FIELD, DURATION_MILLIS_FIELD, SAMPLE_RATE_FIELD, NUMBER_OF_CHANNELS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String codec;
    private final Long durationMillis;
    private final Long sampleRate;
    private final Long numberOfChannels;

    private AudioMetadata(BuilderImpl builder) {
        this.codec = builder.codec;
        this.durationMillis = builder.durationMillis;
        this.sampleRate = builder.sampleRate;
        this.numberOfChannels = builder.numberOfChannels;
    }

    public String codec() {
        return this.codec;
    }

    public Long durationMillis() {
        return this.durationMillis;
    }

    public Long sampleRate() {
        return this.sampleRate;
    }

    public Long numberOfChannels() {
        return this.numberOfChannels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codec());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfChannels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioMetadata)) {
            return false;
        }
        AudioMetadata other = (AudioMetadata)obj;
        return Objects.equals(this.codec(), other.codec()) && Objects.equals(this.durationMillis(), other.durationMillis()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.numberOfChannels(), other.numberOfChannels());
    }

    public String toString() {
        return ToString.builder((String)"AudioMetadata").add("Codec", (Object)this.codec()).add("DurationMillis", (Object)this.durationMillis()).add("SampleRate", (Object)this.sampleRate()).add("NumberOfChannels", (Object)this.numberOfChannels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codec()));
            }
            case "DurationMillis": {
                return Optional.ofNullable(clazz.cast(this.durationMillis()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "NumberOfChannels": {
                return Optional.ofNullable(clazz.cast(this.numberOfChannels()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioMetadata, T> g) {
        return obj -> g.apply((AudioMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String codec;
        private Long durationMillis;
        private Long sampleRate;
        private Long numberOfChannels;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioMetadata model) {
            this.codec(model.codec);
            this.durationMillis(model.durationMillis);
            this.sampleRate(model.sampleRate);
            this.numberOfChannels(model.numberOfChannels);
        }

        public final String getCodec() {
            return this.codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final Long getDurationMillis() {
            return this.durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        public final Long getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(Long sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Long sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final Long getNumberOfChannels() {
            return this.numberOfChannels;
        }

        @Override
        public final Builder numberOfChannels(Long numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
            return this;
        }

        public final void setNumberOfChannels(Long numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
        }

        public AudioMetadata build() {
            return new AudioMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioMetadata> {
        public Builder codec(String var1);

        public Builder durationMillis(Long var1);

        public Builder sampleRate(Long var1);

        public Builder numberOfChannels(Long var1);
    }
}

