/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the pose of the face as determined by its pitch, roll, and yaw.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Pose implements SdkPojo, Serializable, ToCopyableBuilder<Pose.Builder, Pose> {
    private static final SdkField<Float> ROLL_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).getter(getter(Pose::roll))
            .setter(setter(Builder::roll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roll").build()).build();

    private static final SdkField<Float> YAW_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).getter(getter(Pose::yaw))
            .setter(setter(Builder::yaw))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Yaw").build()).build();

    private static final SdkField<Float> PITCH_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(Pose::pitch)).setter(setter(Builder::pitch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pitch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLL_FIELD, YAW_FIELD,
            PITCH_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float roll;

    private final Float yaw;

    private final Float pitch;

    private Pose(BuilderImpl builder) {
        this.roll = builder.roll;
        this.yaw = builder.yaw;
        this.pitch = builder.pitch;
    }

    /**
     * <p>
     * Value representing the face rotation on the roll axis.
     * </p>
     * 
     * @return Value representing the face rotation on the roll axis.
     */
    public Float roll() {
        return roll;
    }

    /**
     * <p>
     * Value representing the face rotation on the yaw axis.
     * </p>
     * 
     * @return Value representing the face rotation on the yaw axis.
     */
    public Float yaw() {
        return yaw;
    }

    /**
     * <p>
     * Value representing the face rotation on the pitch axis.
     * </p>
     * 
     * @return Value representing the face rotation on the pitch axis.
     */
    public Float pitch() {
        return pitch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roll());
        hashCode = 31 * hashCode + Objects.hashCode(yaw());
        hashCode = 31 * hashCode + Objects.hashCode(pitch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pose)) {
            return false;
        }
        Pose other = (Pose) obj;
        return Objects.equals(roll(), other.roll()) && Objects.equals(yaw(), other.yaw())
                && Objects.equals(pitch(), other.pitch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Pose").add("Roll", roll()).add("Yaw", yaw()).add("Pitch", pitch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Roll":
            return Optional.ofNullable(clazz.cast(roll()));
        case "Yaw":
            return Optional.ofNullable(clazz.cast(yaw()));
        case "Pitch":
            return Optional.ofNullable(clazz.cast(pitch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Pose, T> g) {
        return obj -> g.apply((Pose) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Pose> {
        /**
         * <p>
         * Value representing the face rotation on the roll axis.
         * </p>
         * 
         * @param roll
         *        Value representing the face rotation on the roll axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roll(Float roll);

        /**
         * <p>
         * Value representing the face rotation on the yaw axis.
         * </p>
         * 
         * @param yaw
         *        Value representing the face rotation on the yaw axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yaw(Float yaw);

        /**
         * <p>
         * Value representing the face rotation on the pitch axis.
         * </p>
         * 
         * @param pitch
         *        Value representing the face rotation on the pitch axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pitch(Float pitch);
    }

    static final class BuilderImpl implements Builder {
        private Float roll;

        private Float yaw;

        private Float pitch;

        private BuilderImpl() {
        }

        private BuilderImpl(Pose model) {
            roll(model.roll);
            yaw(model.yaw);
            pitch(model.pitch);
        }

        public final Float getRoll() {
            return roll;
        }

        @Override
        public final Builder roll(Float roll) {
            this.roll = roll;
            return this;
        }

        public final void setRoll(Float roll) {
            this.roll = roll;
        }

        public final Float getYaw() {
            return yaw;
        }

        @Override
        public final Builder yaw(Float yaw) {
            this.yaw = yaw;
            return this;
        }

        public final void setYaw(Float yaw) {
            this.yaw = yaw;
        }

        public final Float getPitch() {
            return pitch;
        }

        @Override
        public final Builder pitch(Float pitch) {
            this.pitch = pitch;
            return this;
        }

        public final void setPitch(Float pitch) {
            this.pitch = pitch;
        }

        @Override
        public Pose build() {
            return new Pose(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
