/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a recognized celebrity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CelebrityDetail implements SdkPojo, Serializable, ToCopyableBuilder<CelebrityDetail.Builder, CelebrityDetail> {
    private static final SdkField<List<String>> URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CelebrityDetail::urls))
            .setter(setter(Builder::urls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Urls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CelebrityDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CelebrityDetail::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(CelebrityDetail::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.<BoundingBox> builder(MarshallingType.SDK_POJO)
            .getter(getter(CelebrityDetail::boundingBox)).setter(setter(Builder::boundingBox)).constructor(BoundingBox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()).build();

    private static final SdkField<FaceDetail> FACE_FIELD = SdkField.<FaceDetail> builder(MarshallingType.SDK_POJO)
            .getter(getter(CelebrityDetail::face)).setter(setter(Builder::face)).constructor(FaceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Face").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URLS_FIELD, NAME_FIELD,
            ID_FIELD, CONFIDENCE_FIELD, BOUNDING_BOX_FIELD, FACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> urls;

    private final String name;

    private final String id;

    private final Float confidence;

    private final BoundingBox boundingBox;

    private final FaceDetail face;

    private CelebrityDetail(BuilderImpl builder) {
        this.urls = builder.urls;
        this.name = builder.name;
        this.id = builder.id;
        this.confidence = builder.confidence;
        this.boundingBox = builder.boundingBox;
        this.face = builder.face;
    }

    /**
     * Returns true if the Urls property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUrls() {
        return urls != null && !(urls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of URLs pointing to additional celebrity information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUrls()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of URLs pointing to additional celebrity information.
     */
    public List<String> urls() {
        return urls;
    }

    /**
     * <p>
     * The name of the celebrity.
     * </p>
     * 
     * @return The name of the celebrity.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier for the celebrity.
     * </p>
     * 
     * @return The unique identifier for the celebrity.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.
     * </p>
     * 
     * @return The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.
     */
    public Float confidence() {
        return confidence;
    }

    /**
     * <p>
     * Bounding box around the body of a celebrity.
     * </p>
     * 
     * @return Bounding box around the body of a celebrity.
     */
    public BoundingBox boundingBox() {
        return boundingBox;
    }

    /**
     * <p>
     * Face details for the recognized celebrity.
     * </p>
     * 
     * @return Face details for the recognized celebrity.
     */
    public FaceDetail face() {
        return face;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(urls());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(face());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CelebrityDetail)) {
            return false;
        }
        CelebrityDetail other = (CelebrityDetail) obj;
        return Objects.equals(urls(), other.urls()) && Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(confidence(), other.confidence()) && Objects.equals(boundingBox(), other.boundingBox())
                && Objects.equals(face(), other.face());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CelebrityDetail").add("Urls", urls()).add("Name", name()).add("Id", id())
                .add("Confidence", confidence()).add("BoundingBox", boundingBox()).add("Face", face()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Urls":
            return Optional.ofNullable(clazz.cast(urls()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        case "Face":
            return Optional.ofNullable(clazz.cast(face()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CelebrityDetail, T> g) {
        return obj -> g.apply((CelebrityDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CelebrityDetail> {
        /**
         * <p>
         * An array of URLs pointing to additional celebrity information.
         * </p>
         * 
         * @param urls
         *        An array of URLs pointing to additional celebrity information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urls(Collection<String> urls);

        /**
         * <p>
         * An array of URLs pointing to additional celebrity information.
         * </p>
         * 
         * @param urls
         *        An array of URLs pointing to additional celebrity information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urls(String... urls);

        /**
         * <p>
         * The name of the celebrity.
         * </p>
         * 
         * @param name
         *        The name of the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier for the celebrity.
         * </p>
         * 
         * @param id
         *        The unique identifier for the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.
         * </p>
         * 
         * @param confidence
         *        The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * Bounding box around the body of a celebrity.
         * </p>
         * 
         * @param boundingBox
         *        Bounding box around the body of a celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(BoundingBox boundingBox);

        /**
         * <p>
         * Bounding box around the body of a celebrity.
         * </p>
         * This is a convenience that creates an instance of the {@link BoundingBox.Builder} avoiding the need to create
         * one manually via {@link BoundingBox#builder()}.
         *
         * When the {@link Consumer} completes, {@link BoundingBox.Builder#build()} is called immediately and its result
         * is passed to {@link #boundingBox(BoundingBox)}.
         * 
         * @param boundingBox
         *        a consumer that will call methods on {@link BoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boundingBox(BoundingBox)
         */
        default Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return boundingBox(BoundingBox.builder().applyMutation(boundingBox).build());
        }

        /**
         * <p>
         * Face details for the recognized celebrity.
         * </p>
         * 
         * @param face
         *        Face details for the recognized celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder face(FaceDetail face);

        /**
         * <p>
         * Face details for the recognized celebrity.
         * </p>
         * This is a convenience that creates an instance of the {@link FaceDetail.Builder} avoiding the need to create
         * one manually via {@link FaceDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link FaceDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #face(FaceDetail)}.
         * 
         * @param face
         *        a consumer that will call methods on {@link FaceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #face(FaceDetail)
         */
        default Builder face(Consumer<FaceDetail.Builder> face) {
            return face(FaceDetail.builder().applyMutation(face).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> urls = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String id;

        private Float confidence;

        private BoundingBox boundingBox;

        private FaceDetail face;

        private BuilderImpl() {
        }

        private BuilderImpl(CelebrityDetail model) {
            urls(model.urls);
            name(model.name);
            id(model.id);
            confidence(model.confidence);
            boundingBox(model.boundingBox);
            face(model.face);
        }

        public final Collection<String> getUrls() {
            return urls;
        }

        @Override
        public final Builder urls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urls(String... urls) {
            urls(Arrays.asList(urls));
            return this;
        }

        public final void setUrls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Float getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public final BoundingBox.Builder getBoundingBox() {
            return boundingBox != null ? boundingBox.toBuilder() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        public final FaceDetail.Builder getFace() {
            return face != null ? face.toBuilder() : null;
        }

        @Override
        public final Builder face(FaceDetail face) {
            this.face = face;
            return this;
        }

        public final void setFace(FaceDetail.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        @Override
        public CelebrityDetail build() {
            return new CelebrityDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
