/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.GetTextDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetTextDetectionResponse;

public class GetTextDetectionIterable
implements SdkIterable<GetTextDetectionResponse> {
    private final RekognitionClient client;
    private final GetTextDetectionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTextDetectionIterable(RekognitionClient client, GetTextDetectionRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetTextDetectionResponseFetcher();
    }

    public Iterator<GetTextDetectionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetTextDetectionResponseFetcher
    implements SyncPageFetcher<GetTextDetectionResponse> {
        private GetTextDetectionResponseFetcher() {
        }

        public boolean hasNextPage(GetTextDetectionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetTextDetectionResponse nextPage(GetTextDetectionResponse previousPage) {
            if (previousPage == null) {
                return GetTextDetectionIterable.this.client.getTextDetection(GetTextDetectionIterable.this.firstRequest);
            }
            return GetTextDetectionIterable.this.client.getTextDetection((GetTextDetectionRequest)((Object)GetTextDetectionIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

