/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.OutputConfig;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.services.rekognition.model.TestingData;
import software.amazon.awssdk.services.rekognition.model.TrainingData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProjectVersionRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, CreateProjectVersionRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProjectVersionRequest.getter(CreateProjectVersionRequest::projectArn)).setter(CreateProjectVersionRequest.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProjectVersionRequest.getter(CreateProjectVersionRequest::versionName)).setter(CreateProjectVersionRequest.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateProjectVersionRequest.getter(CreateProjectVersionRequest::outputConfig)).setter(CreateProjectVersionRequest.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<TrainingData> TRAINING_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateProjectVersionRequest.getter(CreateProjectVersionRequest::trainingData)).setter(CreateProjectVersionRequest.setter(Builder::trainingData)).constructor(TrainingData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingData").build()}).build();
    private static final SdkField<TestingData> TESTING_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateProjectVersionRequest.getter(CreateProjectVersionRequest::testingData)).setter(CreateProjectVersionRequest.setter(Builder::testingData)).constructor(TestingData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestingData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, VERSION_NAME_FIELD, OUTPUT_CONFIG_FIELD, TRAINING_DATA_FIELD, TESTING_DATA_FIELD));
    private final String projectArn;
    private final String versionName;
    private final OutputConfig outputConfig;
    private final TrainingData trainingData;
    private final TestingData testingData;

    private CreateProjectVersionRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.versionName = builder.versionName;
        this.outputConfig = builder.outputConfig;
        this.trainingData = builder.trainingData;
        this.testingData = builder.testingData;
    }

    public String projectArn() {
        return this.projectArn;
    }

    public String versionName() {
        return this.versionName;
    }

    public OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public TrainingData trainingData() {
        return this.trainingData;
    }

    public TestingData testingData() {
        return this.testingData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingData());
        hashCode = 31 * hashCode + Objects.hashCode(this.testingData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectVersionRequest)) {
            return false;
        }
        CreateProjectVersionRequest other = (CreateProjectVersionRequest)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.trainingData(), other.trainingData()) && Objects.equals(this.testingData(), other.testingData());
    }

    public String toString() {
        return ToString.builder((String)"CreateProjectVersionRequest").add("ProjectArn", (Object)this.projectArn()).add("VersionName", (Object)this.versionName()).add("OutputConfig", (Object)this.outputConfig()).add("TrainingData", (Object)this.trainingData()).add("TestingData", (Object)this.testingData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "VersionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "TrainingData": {
                return Optional.ofNullable(clazz.cast(this.trainingData()));
            }
            case "TestingData": {
                return Optional.ofNullable(clazz.cast(this.testingData()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectVersionRequest, T> g) {
        return obj -> g.apply((CreateProjectVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String projectArn;
        private String versionName;
        private OutputConfig outputConfig;
        private TrainingData trainingData;
        private TestingData testingData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectVersionRequest model) {
            super(model);
            this.projectArn(model.projectArn);
            this.versionName(model.versionName);
            this.outputConfig(model.outputConfig);
            this.trainingData(model.trainingData);
            this.testingData(model.testingData);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final TrainingData.Builder getTrainingData() {
            return this.trainingData != null ? this.trainingData.toBuilder() : null;
        }

        @Override
        public final Builder trainingData(TrainingData trainingData) {
            this.trainingData = trainingData;
            return this;
        }

        public final void setTrainingData(TrainingData.BuilderImpl trainingData) {
            this.trainingData = trainingData != null ? trainingData.build() : null;
        }

        public final TestingData.Builder getTestingData() {
            return this.testingData != null ? this.testingData.toBuilder() : null;
        }

        @Override
        public final Builder testingData(TestingData testingData) {
            this.testingData = testingData;
            return this;
        }

        public final void setTestingData(TestingData.BuilderImpl testingData) {
            this.testingData = testingData != null ? testingData.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectVersionRequest build() {
            return new CreateProjectVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProjectVersionRequest> {
        public Builder projectArn(String var1);

        public Builder versionName(String var1);

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder trainingData(TrainingData var1);

        default public Builder trainingData(Consumer<TrainingData.Builder> trainingData) {
            return this.trainingData((TrainingData)((TrainingData.Builder)TrainingData.builder().applyMutation(trainingData)).build());
        }

        public Builder testingData(TestingData var1);

        default public Builder testingData(Consumer<TestingData.Builder> testingData) {
            return this.testingData((TestingData)((TestingData.Builder)TestingData.builder().applyMutation(testingData)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

