/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse;

public class GetLabelDetectionIterable
implements SdkIterable<GetLabelDetectionResponse> {
    private final RekognitionClient client;
    private final GetLabelDetectionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetLabelDetectionIterable(RekognitionClient client, GetLabelDetectionRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetLabelDetectionResponseFetcher();
    }

    public Iterator<GetLabelDetectionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetLabelDetectionIterable resume(GetLabelDetectionResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetLabelDetectionIterable(this.client, (GetLabelDetectionRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetLabelDetectionIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetLabelDetectionResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetLabelDetectionResponseFetcher
    implements SyncPageFetcher<GetLabelDetectionResponse> {
        private GetLabelDetectionResponseFetcher() {
        }

        public boolean hasNextPage(GetLabelDetectionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetLabelDetectionResponse nextPage(GetLabelDetectionResponse previousPage) {
            if (previousPage == null) {
                return GetLabelDetectionIterable.this.client.getLabelDetection(GetLabelDetectionIterable.this.firstRequest);
            }
            return GetLabelDetectionIterable.this.client.getLabelDetection((GetLabelDetectionRequest)((Object)GetLabelDetectionIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

