/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse;

public class GetCelebrityRecognitionIterable
implements SdkIterable<GetCelebrityRecognitionResponse> {
    private final RekognitionClient client;
    private final GetCelebrityRecognitionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCelebrityRecognitionIterable(RekognitionClient client, GetCelebrityRecognitionRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetCelebrityRecognitionResponseFetcher();
    }

    public Iterator<GetCelebrityRecognitionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetCelebrityRecognitionIterable resume(GetCelebrityRecognitionResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetCelebrityRecognitionIterable(this.client, (GetCelebrityRecognitionRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetCelebrityRecognitionIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetCelebrityRecognitionResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetCelebrityRecognitionResponseFetcher
    implements SyncPageFetcher<GetCelebrityRecognitionResponse> {
        private GetCelebrityRecognitionResponseFetcher() {
        }

        public boolean hasNextPage(GetCelebrityRecognitionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCelebrityRecognitionResponse nextPage(GetCelebrityRecognitionResponse previousPage) {
            if (previousPage == null) {
                return GetCelebrityRecognitionIterable.this.client.getCelebrityRecognition(GetCelebrityRecognitionIterable.this.firstRequest);
            }
            return GetCelebrityRecognitionIterable.this.client.getCelebrityRecognition((GetCelebrityRecognitionRequest)((Object)GetCelebrityRecognitionIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

