/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.LandmarkType;
import software.amazon.awssdk.services.rekognition.transform.LandmarkMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Landmark
implements StructuredPojo,
ToCopyableBuilder<Builder, Landmark> {
    private final String type;
    private final Float x;
    private final Float y;

    private Landmark(BuilderImpl builder) {
        this.type = builder.type;
        this.x = builder.x;
        this.y = builder.y;
    }

    public String type() {
        return this.type;
    }

    public Float x() {
        return this.x;
    }

    public Float y() {
        return this.y;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.x() == null ? 0 : this.x().hashCode());
        hashCode = 31 * hashCode + (this.y() == null ? 0 : this.y().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Landmark)) {
            return false;
        }
        Landmark other = (Landmark)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.x() == null ^ this.x() == null) {
            return false;
        }
        if (other.x() != null && !other.x().equals(this.x())) {
            return false;
        }
        if (other.y() == null ^ this.y() == null) {
            return false;
        }
        return other.y() == null || other.y().equals(this.y());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.x() != null) {
            sb.append("X: ").append(this.x()).append(",");
        }
        if (this.y() != null) {
            sb.append("Y: ").append(this.y()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LandmarkMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private Float x;
        private Float y;

        private BuilderImpl() {
        }

        private BuilderImpl(Landmark model) {
            this.setType(model.type);
            this.setX(model.x);
            this.setY(model.y);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LandmarkType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(LandmarkType type) {
            this.type(type.toString());
        }

        public final Float getX() {
            return this.x;
        }

        @Override
        public final Builder x(Float x) {
            this.x = x;
            return this;
        }

        public final void setX(Float x) {
            this.x = x;
        }

        public final Float getY() {
            return this.y;
        }

        @Override
        public final Builder y(Float y) {
            this.y = y;
            return this;
        }

        public final void setY(Float y) {
            this.y = y;
        }

        public Landmark build() {
            return new Landmark(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Landmark> {
        public Builder type(String var1);

        public Builder type(LandmarkType var1);

        public Builder x(Float var1);

        public Builder y(Float var1);
    }
}

