/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.transform.FaceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Face
implements StructuredPojo,
ToCopyableBuilder<Builder, Face> {
    private final String faceId;
    private final BoundingBox boundingBox;
    private final String imageId;
    private final String externalImageId;
    private final Float confidence;

    private Face(BuilderImpl builder) {
        this.faceId = builder.faceId;
        this.boundingBox = builder.boundingBox;
        this.imageId = builder.imageId;
        this.externalImageId = builder.externalImageId;
        this.confidence = builder.confidence;
    }

    public String faceId() {
        return this.faceId;
    }

    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public String imageId() {
        return this.imageId;
    }

    public String externalImageId() {
        return this.externalImageId;
    }

    public Float confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.faceId() == null ? 0 : this.faceId().hashCode());
        hashCode = 31 * hashCode + (this.boundingBox() == null ? 0 : this.boundingBox().hashCode());
        hashCode = 31 * hashCode + (this.imageId() == null ? 0 : this.imageId().hashCode());
        hashCode = 31 * hashCode + (this.externalImageId() == null ? 0 : this.externalImageId().hashCode());
        hashCode = 31 * hashCode + (this.confidence() == null ? 0 : this.confidence().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Face)) {
            return false;
        }
        Face other = (Face)obj;
        if (other.faceId() == null ^ this.faceId() == null) {
            return false;
        }
        if (other.faceId() != null && !other.faceId().equals(this.faceId())) {
            return false;
        }
        if (other.boundingBox() == null ^ this.boundingBox() == null) {
            return false;
        }
        if (other.boundingBox() != null && !other.boundingBox().equals(this.boundingBox())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.externalImageId() == null ^ this.externalImageId() == null) {
            return false;
        }
        if (other.externalImageId() != null && !other.externalImageId().equals(this.externalImageId())) {
            return false;
        }
        if (other.confidence() == null ^ this.confidence() == null) {
            return false;
        }
        return other.confidence() == null || other.confidence().equals(this.confidence());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.faceId() != null) {
            sb.append("FaceId: ").append(this.faceId()).append(",");
        }
        if (this.boundingBox() != null) {
            sb.append("BoundingBox: ").append(this.boundingBox()).append(",");
        }
        if (this.imageId() != null) {
            sb.append("ImageId: ").append(this.imageId()).append(",");
        }
        if (this.externalImageId() != null) {
            sb.append("ExternalImageId: ").append(this.externalImageId()).append(",");
        }
        if (this.confidence() != null) {
            sb.append("Confidence: ").append(this.confidence()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String faceId;
        private BoundingBox boundingBox;
        private String imageId;
        private String externalImageId;
        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Face model) {
            this.setFaceId(model.faceId);
            this.setBoundingBox(model.boundingBox);
            this.setImageId(model.imageId);
            this.setExternalImageId(model.externalImageId);
            this.setConfidence(model.confidence);
        }

        public final String getFaceId() {
            return this.faceId;
        }

        @Override
        public final Builder faceId(String faceId) {
            this.faceId = faceId;
            return this;
        }

        public final void setFaceId(String faceId) {
            this.faceId = faceId;
        }

        public final BoundingBox getBoundingBox() {
            return this.boundingBox;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getExternalImageId() {
            return this.externalImageId;
        }

        @Override
        public final Builder externalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
            return this;
        }

        public final void setExternalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public Face build() {
            return new Face(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Face> {
        public Builder faceId(String var1);

        public Builder boundingBox(BoundingBox var1);

        public Builder imageId(String var1);

        public Builder externalImageId(String var1);

        public Builder confidence(Float var1);
    }
}

