/*
 * Copyright 2021-2026 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.EndpointTag;
import software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Pair;

@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public final class ApiEcrServiceMetadata implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "api.ecr";

    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("af-south-1"),
            Region.of("ap-east-1"), Region.of("ap-east-2"), Region.of("ap-northeast-1"), Region.of("ap-northeast-2"),
            Region.of("ap-northeast-3"), Region.of("ap-south-1"), Region.of("ap-south-2"), Region.of("ap-southeast-1"),
            Region.of("ap-southeast-2"), Region.of("ap-southeast-3"), Region.of("ap-southeast-4"), Region.of("ap-southeast-5"),
            Region.of("ap-southeast-6"), Region.of("ap-southeast-7"), Region.of("ca-central-1"), Region.of("ca-west-1"),
            Region.of("eu-central-1"), Region.of("eu-central-2"), Region.of("eu-north-1"), Region.of("eu-south-1"),
            Region.of("eu-south-2"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("eu-west-3"),
            Region.of("fips-us-east-1"), Region.of("fips-us-east-2"), Region.of("fips-us-west-1"), Region.of("fips-us-west-2"),
            Region.of("il-central-1"), Region.of("me-central-1"), Region.of("me-south-1"), Region.of("mx-central-1"),
            Region.of("sa-east-1"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-west-1"),
            Region.of("us-west-2"), Region.of("cn-north-1"), Region.of("cn-northwest-1"), Region.of("fips-us-gov-east-1"),
            Region.of("fips-us-gov-west-1"), Region.of("us-gov-east-1"), Region.of("us-gov-west-1"), Region.of("us-iso-east-1"),
            Region.of("us-iso-west-1"), Region.of("us-isob-east-1"), Region.of("us-isob-west-1"), Region.of("eu-isoe-west-1"),
            Region.of("us-isof-east-1"), Region.of("us-isof-south-1"), Region.of("eusc-de-east-1")));

    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(
            new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null),
            new DefaultServicePartitionMetadata("aws-us-gov", null), new DefaultServicePartitionMetadata("aws-iso", null),
            new DefaultServicePartitionMetadata("aws-iso-b", null), new DefaultServicePartitionMetadata("aws-iso-e", null),
            new DefaultServicePartitionMetadata("aws-iso-f", null), new DefaultServicePartitionMetadata("aws-eusc", null)));

    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap
            .<ServiceEndpointKey, String> builder()
            .put(ServiceEndpointKey.builder().region(Region.of("af-south-1")).build(), "af-south-1")
            .put(ServiceEndpointKey.builder().region(Region.of("af-south-1")).tags(EndpointTag.of("dualstack")).build(),
                    "af-south-1")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-east-1")).build(), "ap-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-east-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ap-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), "ap-northeast-1")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ap-northeast-1")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), "ap-northeast-2")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).tags(EndpointTag.of("dualstack")).build(),
                    "ap-northeast-2")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).build(), "ap-northeast-3")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).tags(EndpointTag.of("dualstack")).build(),
                    "ap-northeast-3")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-south-1")).build(), "ap-south-1")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-south-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ap-south-1")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-south-2")).build(), "ap-south-2")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-south-2")).tags(EndpointTag.of("dualstack")).build(),
                    "ap-south-2")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), "ap-southeast-1")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ap-southeast-1")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), "ap-southeast-2")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).tags(EndpointTag.of("dualstack")).build(),
                    "ap-southeast-2")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-3")).build(), "ap-southeast-3")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-3")).tags(EndpointTag.of("dualstack")).build(),
                    "ap-southeast-3")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).build(), "ap-southeast-4")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).tags(EndpointTag.of("dualstack")).build(),
                    "ap-southeast-4")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-5")).build(), "ap-southeast-5")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-5")).tags(EndpointTag.of("dualstack")).build(),
                    "ap-southeast-5")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-7")).build(), "ap-southeast-7")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-7")).tags(EndpointTag.of("dualstack")).build(),
                    "ap-southeast-7")
            .put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).build(), "ca-central-1")
            .put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ca-central-1")
            .put(ServiceEndpointKey.builder().region(Region.of("ca-west-1")).build(), "ca-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("ca-west-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ca-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), "eu-central-1")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-central-1")).tags(EndpointTag.of("dualstack")).build(),
                    "eu-central-1")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-central-2")).build(), "eu-central-2")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-central-2")).tags(EndpointTag.of("dualstack")).build(),
                    "eu-central-2")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-north-1")).build(), "eu-north-1")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-north-1")).tags(EndpointTag.of("dualstack")).build(),
                    "eu-north-1")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-south-1")).build(), "eu-south-1")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-south-1")).tags(EndpointTag.of("dualstack")).build(),
                    "eu-south-1")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-south-2")).build(), "eu-south-2")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-south-2")).tags(EndpointTag.of("dualstack")).build(),
                    "eu-south-2")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), "eu-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-west-1")).tags(EndpointTag.of("dualstack")).build(),
                    "eu-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), "eu-west-2")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-west-2")).tags(EndpointTag.of("dualstack")).build(),
                    "eu-west-2")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-west-3")).build(), "eu-west-3")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-west-3")).tags(EndpointTag.of("dualstack")).build(),
                    "eu-west-3")
            .put(ServiceEndpointKey.builder().region(Region.of("fips-us-east-1")).build(), "us-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("fips-us-east-2")).build(), "us-east-2")
            .put(ServiceEndpointKey.builder().region(Region.of("fips-us-west-1")).build(), "us-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("fips-us-west-2")).build(), "us-west-2")
            .put(ServiceEndpointKey.builder().region(Region.of("il-central-1")).build(), "il-central-1")
            .put(ServiceEndpointKey.builder().region(Region.of("il-central-1")).tags(EndpointTag.of("dualstack")).build(),
                    "il-central-1")
            .put(ServiceEndpointKey.builder().region(Region.of("me-central-1")).build(), "me-central-1")
            .put(ServiceEndpointKey.builder().region(Region.of("me-central-1")).tags(EndpointTag.of("dualstack")).build(),
                    "me-central-1")
            .put(ServiceEndpointKey.builder().region(Region.of("me-south-1")).build(), "me-south-1")
            .put(ServiceEndpointKey.builder().region(Region.of("me-south-1")).tags(EndpointTag.of("dualstack")).build(),
                    "me-south-1")
            .put(ServiceEndpointKey.builder().region(Region.of("mx-central-1")).build(), "mx-central-1")
            .put(ServiceEndpointKey.builder().region(Region.of("mx-central-1")).tags(EndpointTag.of("dualstack")).build(),
                    "mx-central-1")
            .put(ServiceEndpointKey.builder().region(Region.of("sa-east-1")).build(), "sa-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("sa-east-1")).tags(EndpointTag.of("dualstack")).build(),
                    "sa-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), "us-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("fips")).build(), "us-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-1"))
                    .tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "us-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("dualstack")).build(),
                    "us-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), "us-east-2")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("fips")).build(), "us-east-2")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-2"))
                    .tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "us-east-2")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("dualstack")).build(),
                    "us-east-2")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).build(), "us-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("fips")).build(), "us-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-1"))
                    .tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "us-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("dualstack")).build(),
                    "us-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), "us-west-2")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("fips")).build(), "us-west-2")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-2"))
                    .tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "us-west-2")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("dualstack")).build(),
                    "us-west-2")
            .put(ServiceEndpointKey.builder().region(Region.of("cn-north-1")).build(), "cn-north-1")
            .put(ServiceEndpointKey.builder().region(Region.of("cn-north-1")).tags(EndpointTag.of("dualstack")).build(),
                    "cn-north-1")
            .put(ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).build(), "cn-northwest-1")
            .put(ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).tags(EndpointTag.of("dualstack")).build(),
                    "cn-northwest-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).build(), "us-iso-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-iso-west-1")).build(), "us-iso-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-isob-east-1")).build(), "us-isob-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-isoe-west-1")).build(), "eu-isoe-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-isof-east-1")).build(), "us-isof-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-isof-south-1")).build(), "us-isof-south-1")
            .put(ServiceEndpointKey.builder().region(Region.of("fips-us-gov-east-1")).build(), "us-gov-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("fips-us-gov-west-1")).build(), "us-gov-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).build(), "us-gov-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("fips")).build(),
                    "us-gov-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1"))
                    .tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "us-gov-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("dualstack")).build(),
                    "us-gov-east-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).build(), "us-gov-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("fips")).build(),
                    "us-gov-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1"))
                    .tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "us-gov-west-1")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("dualstack")).build(),
                    "us-gov-west-1").build();

    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap
            .<Pair<String, PartitionEndpointKey>, String> builder().build();

    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap
            .<ServiceEndpointKey, String> builder().build();

    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap
            .<Pair<String, PartitionEndpointKey>, String> builder().build();

    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap
            .<ServiceEndpointKey, String> builder()
            .allowDuplicateKeys(true)
            .put(ServiceEndpointKey.builder().region(Region.of("af-south-1")).build(), "api.ecr.af-south-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("af-south-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.af-south-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-east-1")).build(), "api.ecr.ap-east-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-east-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.ap-east-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), "api.ecr.ap-northeast-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.ap-northeast-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), "api.ecr.ap-northeast-2.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.ap-northeast-2.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).build(), "api.ecr.ap-northeast-3.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.ap-northeast-3.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-south-1")).build(), "api.ecr.ap-south-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-south-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.ap-south-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-south-2")).build(), "api.ecr.ap-south-2.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-south-2")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.ap-south-2.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), "api.ecr.ap-southeast-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.ap-southeast-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), "api.ecr.ap-southeast-2.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.ap-southeast-2.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-3")).build(), "api.ecr.ap-southeast-3.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-3")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.ap-southeast-3.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).build(), "api.ecr.ap-southeast-4.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.ap-southeast-4.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-5")).build(), "api.ecr.ap-southeast-5.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-5")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.ap-southeast-5.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-7")).build(), "api.ecr.ap-southeast-7.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-7")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.ap-southeast-7.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).build(), "api.ecr.ca-central-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.ca-central-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ca-west-1")).build(), "api.ecr.ca-west-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("ca-west-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.ca-west-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), "api.ecr.eu-central-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-central-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.eu-central-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-central-2")).build(), "api.ecr.eu-central-2.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-central-2")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.eu-central-2.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-north-1")).build(), "api.ecr.eu-north-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-north-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.eu-north-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-south-1")).build(), "api.ecr.eu-south-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-south-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.eu-south-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-south-2")).build(), "api.ecr.eu-south-2.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-south-2")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.eu-south-2.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), "api.ecr.eu-west-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-west-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.eu-west-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), "api.ecr.eu-west-2.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-west-2")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.eu-west-2.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-west-3")).build(), "api.ecr.eu-west-3.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-west-3")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.eu-west-3.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("fips-us-east-1")).build(), "ecr-fips.us-east-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("fips-us-east-2")).build(), "ecr-fips.us-east-2.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("fips-us-west-1")).build(), "ecr-fips.us-west-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("fips-us-west-2")).build(), "ecr-fips.us-west-2.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("il-central-1")).build(), "api.ecr.il-central-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("il-central-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.il-central-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("me-central-1")).build(), "api.ecr.me-central-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("me-central-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.me-central-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("me-south-1")).build(), "api.ecr.me-south-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("me-south-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.me-south-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("mx-central-1")).build(), "api.ecr.mx-central-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("mx-central-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.mx-central-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("sa-east-1")).build(), "api.ecr.sa-east-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("sa-east-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.sa-east-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), "api.ecr.us-east-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("fips")).build(),
                    "ecr-fips.us-east-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-1"))
                    .tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "ecr-fips.us-east-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.us-east-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), "api.ecr.us-east-2.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("fips")).build(),
                    "ecr-fips.us-east-2.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-2"))
                    .tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "ecr-fips.us-east-2.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.us-east-2.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).build(), "api.ecr.us-west-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("fips")).build(),
                    "ecr-fips.us-west-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-1"))
                    .tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "ecr-fips.us-west-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.us-west-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), "api.ecr.us-west-2.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("fips")).build(),
                    "ecr-fips.us-west-2.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-2"))
                    .tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "ecr-fips.us-west-2.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.us-west-2.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("cn-north-1")).build(), "api.ecr.cn-north-1.amazonaws.com.cn")
            .put(ServiceEndpointKey.builder().region(Region.of("cn-north-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.cn-north-1.api.amazonwebservices.com.cn")
            .put(ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).build(),
                    "api.ecr.cn-northwest-1.amazonaws.com.cn")
            .put(ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.cn-northwest-1.api.amazonwebservices.com.cn")
            .put(ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).build(), "api.ecr.us-iso-east-1.c2s.ic.gov")
            .put(ServiceEndpointKey.builder().region(Region.of("us-iso-west-1")).build(), "api.ecr.us-iso-west-1.c2s.ic.gov")
            .put(ServiceEndpointKey.builder().region(Region.of("us-isob-east-1")).build(), "api.ecr.us-isob-east-1.sc2s.sgov.gov")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-isoe-west-1")).build(),
                    "api.ecr.eu-isoe-west-1.cloud.adc-e.uk")
            .put(ServiceEndpointKey.builder().region(Region.of("us-isof-east-1")).build(),
                    "api.ecr.us-isof-east-1.csp.hci.ic.gov")
            .put(ServiceEndpointKey.builder().region(Region.of("us-isof-south-1")).build(),
                    "api.ecr.us-isof-south-1.csp.hci.ic.gov")
            .put(ServiceEndpointKey.builder().region(Region.of("fips-us-gov-east-1")).build(),
                    "ecr-fips.us-gov-east-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("fips-us-gov-west-1")).build(),
                    "ecr-fips.us-gov-west-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).build(), "api.ecr.us-gov-east-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("fips")).build(),
                    "ecr-fips.us-gov-east-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1"))
                    .tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "ecr-fips.us-gov-east-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.us-gov-east-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).build(), "api.ecr.us-gov-west-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("fips")).build(),
                    "ecr-fips.us-gov-west-1.amazonaws.com")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1"))
                    .tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), "ecr-fips.us-gov-west-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("dualstack")).build(),
                    "ecr.us-gov-west-1.api.aws").build();

    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap
            .<Pair<String, PartitionEndpointKey>, String> builder()
            .put(Pair.of("aws", PartitionEndpointKey.builder().tags(EndpointTag.of("fips")).build()),
                    "ecr-fips.{region}.{dnsSuffix}")
            .put(Pair.of("aws-us-gov", PartitionEndpointKey.builder().tags(EndpointTag.of("fips")).build()),
                    "ecr-fips.{region}.{dnsSuffix}").build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION),
                ENDPOINT_PREFIX, key.region().id(),
                ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}
