/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.utils.ImmutableMap;

@SdkPublicApi
public final class KmsServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "kms";
    private static final Map<String, String> PARTITION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().build();
    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().put((Object)"af-south-1-fips", (Object)"kms-fips.af-south-1.amazonaws.com").put((Object)"ap-east-1-fips", (Object)"kms-fips.ap-east-1.amazonaws.com").put((Object)"ap-northeast-1-fips", (Object)"kms-fips.ap-northeast-1.amazonaws.com").put((Object)"ap-northeast-2-fips", (Object)"kms-fips.ap-northeast-2.amazonaws.com").put((Object)"ap-northeast-3-fips", (Object)"kms-fips.ap-northeast-3.amazonaws.com").put((Object)"ap-south-1-fips", (Object)"kms-fips.ap-south-1.amazonaws.com").put((Object)"ap-southeast-1-fips", (Object)"kms-fips.ap-southeast-1.amazonaws.com").put((Object)"ap-southeast-2-fips", (Object)"kms-fips.ap-southeast-2.amazonaws.com").put((Object)"ca-central-1-fips", (Object)"kms-fips.ca-central-1.amazonaws.com").put((Object)"eu-central-1-fips", (Object)"kms-fips.eu-central-1.amazonaws.com").put((Object)"eu-north-1-fips", (Object)"kms-fips.eu-north-1.amazonaws.com").put((Object)"eu-south-1-fips", (Object)"kms-fips.eu-south-1.amazonaws.com").put((Object)"eu-west-1-fips", (Object)"kms-fips.eu-west-1.amazonaws.com").put((Object)"eu-west-2-fips", (Object)"kms-fips.eu-west-2.amazonaws.com").put((Object)"eu-west-3-fips", (Object)"kms-fips.eu-west-3.amazonaws.com").put((Object)"me-south-1-fips", (Object)"kms-fips.me-south-1.amazonaws.com").put((Object)"sa-east-1-fips", (Object)"kms-fips.sa-east-1.amazonaws.com").put((Object)"us-east-1-fips", (Object)"kms-fips.us-east-1.amazonaws.com").put((Object)"us-east-2-fips", (Object)"kms-fips.us-east-2.amazonaws.com").put((Object)"us-west-1-fips", (Object)"kms-fips.us-west-1.amazonaws.com").put((Object)"us-west-2-fips", (Object)"kms-fips.us-west-2.amazonaws.com").put((Object)"us-iso-east-1-fips", (Object)"kms-fips.us-iso-east-1.c2s.ic.gov").put((Object)"us-iso-west-1-fips", (Object)"kms-fips.us-iso-west-1.c2s.ic.gov").put((Object)"us-isob-east-1-fips", (Object)"kms-fips.us-isob-east-1.sc2s.sgov.gov").put((Object)"us-gov-east-1-fips", (Object)"kms-fips.us-gov-east-1.amazonaws.com").put((Object)"us-gov-west-1-fips", (Object)"kms-fips.us-gov-west-1.amazonaws.com").build();
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("af-south-1"), Region.of("af-south-1-fips"), Region.of("ap-east-1"), Region.of("ap-east-1-fips"), Region.of("ap-northeast-1"), Region.of("ap-northeast-1-fips"), Region.of("ap-northeast-2"), Region.of("ap-northeast-2-fips"), Region.of("ap-northeast-3"), Region.of("ap-northeast-3-fips"), Region.of("ap-south-1"), Region.of("ap-south-1-fips"), Region.of("ap-southeast-1"), Region.of("ap-southeast-1-fips"), Region.of("ap-southeast-2"), Region.of("ap-southeast-2-fips"), Region.of("ca-central-1"), Region.of("ca-central-1-fips"), Region.of("eu-central-1"), Region.of("eu-central-1-fips"), Region.of("eu-north-1"), Region.of("eu-north-1-fips"), Region.of("eu-south-1"), Region.of("eu-south-1-fips"), Region.of("eu-west-1"), Region.of("eu-west-1-fips"), Region.of("eu-west-2"), Region.of("eu-west-2-fips"), Region.of("eu-west-3"), Region.of("eu-west-3-fips"), Region.of("me-south-1"), Region.of("me-south-1-fips"), Region.of("sa-east-1"), Region.of("sa-east-1-fips"), Region.of("us-east-1"), Region.of("us-east-1-fips"), Region.of("us-east-2"), Region.of("us-east-2-fips"), Region.of("us-west-1"), Region.of("us-west-1-fips"), Region.of("us-west-2"), Region.of("us-west-2-fips"), Region.of("cn-north-1"), Region.of("cn-northwest-1"), Region.of("us-gov-east-1"), Region.of("us-gov-east-1-fips"), Region.of("us-gov-west-1"), Region.of("us-gov-west-1-fips"), Region.of("us-iso-east-1"), Region.of("us-iso-east-1-fips"), Region.of("us-iso-west-1"), Region.of("us-iso-west-1-fips"), Region.of("us-isob-east-1"), Region.of("us-isob-east-1-fips")));
    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.builder().put((Object)"af-south-1-fips", (Object)"af-south-1").put((Object)"ap-east-1-fips", (Object)"ap-east-1").put((Object)"ap-northeast-1-fips", (Object)"ap-northeast-1").put((Object)"ap-northeast-2-fips", (Object)"ap-northeast-2").put((Object)"ap-northeast-3-fips", (Object)"ap-northeast-3").put((Object)"ap-south-1-fips", (Object)"ap-south-1").put((Object)"ap-southeast-1-fips", (Object)"ap-southeast-1").put((Object)"ap-southeast-2-fips", (Object)"ap-southeast-2").put((Object)"ca-central-1-fips", (Object)"ca-central-1").put((Object)"eu-central-1-fips", (Object)"eu-central-1").put((Object)"eu-north-1-fips", (Object)"eu-north-1").put((Object)"eu-south-1-fips", (Object)"eu-south-1").put((Object)"eu-west-1-fips", (Object)"eu-west-1").put((Object)"eu-west-2-fips", (Object)"eu-west-2").put((Object)"eu-west-3-fips", (Object)"eu-west-3").put((Object)"me-south-1-fips", (Object)"me-south-1").put((Object)"sa-east-1-fips", (Object)"sa-east-1").put((Object)"us-east-1-fips", (Object)"us-east-1").put((Object)"us-east-2-fips", (Object)"us-east-2").put((Object)"us-west-1-fips", (Object)"us-west-1").put((Object)"us-west-2-fips", (Object)"us-west-2").put((Object)"us-iso-east-1-fips", (Object)"us-iso-east-1").put((Object)"us-iso-west-1-fips", (Object)"us-iso-west-1").put((Object)"us-isob-east-1-fips", (Object)"us-isob-east-1").put((Object)"us-gov-east-1-fips", (Object)"us-gov-east-1").put((Object)"us-gov-west-1-fips", (Object)"us-gov-west-1").build();
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null), new DefaultServicePartitionMetadata("aws-us-gov", null), new DefaultServicePartitionMetadata("aws-iso", null), new DefaultServicePartitionMetadata("aws-iso-b", null)));

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id()) : this.computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region));
    }

    @Override
    public Region signingRegion(Region region) {
        return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()));
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }
}

