/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.utils.ImmutableMap;

@SdkPublicApi
public final class SupportServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "support";
    private static final Map<String, String> PARTITION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().build();
    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().put((Object)"aws-global", (Object)"support.us-east-1.amazonaws.com").put((Object)"aws-cn-global", (Object)"support.cn-north-1.amazonaws.com.cn").put((Object)"aws-iso-global", (Object)"support.us-iso-east-1.c2s.ic.gov").put((Object)"aws-iso-b-global", (Object)"support.us-isob-east-1.sc2s.sgov.gov").build();
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("aws-global"), Region.of("aws-cn-global"), Region.of("aws-iso-global"), Region.of("aws-iso-b-global")));
    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.builder().put((Object)"aws-global", (Object)"us-east-1").put((Object)"aws-cn-global", (Object)"cn-north-1").put((Object)"aws-iso-global", (Object)"us-iso-east-1").put((Object)"aws-iso-b-global", (Object)"us-isob-east-1").build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id()) : this.computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region));
    }

    @Override
    public Region signingRegion(Region region) {
        return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()));
    }
}

