/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.Association;
import software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse;

public class ListCustomDomainAssociationsPublisher
implements SdkPublisher<ListCustomDomainAssociationsResponse> {
    private final RedshiftServerlessAsyncClient client;
    private final ListCustomDomainAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomDomainAssociationsPublisher(RedshiftServerlessAsyncClient client, ListCustomDomainAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomDomainAssociationsPublisher(RedshiftServerlessAsyncClient client, ListCustomDomainAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomDomainAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomDomainAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Association> associations() {
        Function<ListCustomDomainAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associations() != null) {
                return response.associations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCustomDomainAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCustomDomainAssociationsResponseFetcher
    implements AsyncPageFetcher<ListCustomDomainAssociationsResponse> {
        private ListCustomDomainAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomDomainAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomDomainAssociationsResponse> nextPage(ListCustomDomainAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomDomainAssociationsPublisher.this.client.listCustomDomainAssociations(ListCustomDomainAssociationsPublisher.this.firstRequest);
            }
            return ListCustomDomainAssociationsPublisher.this.client.listCustomDomainAssociations((ListCustomDomainAssociationsRequest)((Object)ListCustomDomainAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

