/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.NextInvocationsListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.Schedule;
import software.amazon.awssdk.services.redshiftserverless.model.State;
import software.amazon.awssdk.services.redshiftserverless.model.TargetAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledActionResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledActionResponse> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ScheduledActionResponse.getter(ScheduledActionResponse::endTime)).setter(ScheduledActionResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(ScheduledActionResponse.getter(ScheduledActionResponse::namespaceName)).setter(ScheduledActionResponse.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<List<Instant>> NEXT_INVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nextInvocations").getter(ScheduledActionResponse.getter(ScheduledActionResponse::nextInvocations)).setter(ScheduledActionResponse.setter(Builder::nextInvocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextInvocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(ScheduledActionResponse.getter(ScheduledActionResponse::roleArn)).setter(ScheduledActionResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(ScheduledActionResponse.getter(ScheduledActionResponse::schedule)).setter(ScheduledActionResponse.setter(Builder::schedule)).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final SdkField<String> SCHEDULED_ACTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheduledActionDescription").getter(ScheduledActionResponse.getter(ScheduledActionResponse::scheduledActionDescription)).setter(ScheduledActionResponse.setter(Builder::scheduledActionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledActionDescription").build()}).build();
    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheduledActionName").getter(ScheduledActionResponse.getter(ScheduledActionResponse::scheduledActionName)).setter(ScheduledActionResponse.setter(Builder::scheduledActionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledActionName").build()}).build();
    private static final SdkField<String> SCHEDULED_ACTION_UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheduledActionUuid").getter(ScheduledActionResponse.getter(ScheduledActionResponse::scheduledActionUuid)).setter(ScheduledActionResponse.setter(Builder::scheduledActionUuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledActionUuid").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ScheduledActionResponse.getter(ScheduledActionResponse::startTime)).setter(ScheduledActionResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ScheduledActionResponse.getter(ScheduledActionResponse::stateAsString)).setter(ScheduledActionResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<TargetAction> TARGET_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetAction").getter(ScheduledActionResponse.getter(ScheduledActionResponse::targetAction)).setter(ScheduledActionResponse.setter(Builder::targetAction)).constructor(TargetAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, NAMESPACE_NAME_FIELD, NEXT_INVOCATIONS_FIELD, ROLE_ARN_FIELD, SCHEDULE_FIELD, SCHEDULED_ACTION_DESCRIPTION_FIELD, SCHEDULED_ACTION_NAME_FIELD, SCHEDULED_ACTION_UUID_FIELD, START_TIME_FIELD, STATE_FIELD, TARGET_ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("endTime", END_TIME_FIELD);
            this.put("namespaceName", NAMESPACE_NAME_FIELD);
            this.put("nextInvocations", NEXT_INVOCATIONS_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("schedule", SCHEDULE_FIELD);
            this.put("scheduledActionDescription", SCHEDULED_ACTION_DESCRIPTION_FIELD);
            this.put("scheduledActionName", SCHEDULED_ACTION_NAME_FIELD);
            this.put("scheduledActionUuid", SCHEDULED_ACTION_UUID_FIELD);
            this.put("startTime", START_TIME_FIELD);
            this.put("state", STATE_FIELD);
            this.put("targetAction", TARGET_ACTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant endTime;
    private final String namespaceName;
    private final List<Instant> nextInvocations;
    private final String roleArn;
    private final Schedule schedule;
    private final String scheduledActionDescription;
    private final String scheduledActionName;
    private final String scheduledActionUuid;
    private final Instant startTime;
    private final String state;
    private final TargetAction targetAction;

    private ScheduledActionResponse(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.namespaceName = builder.namespaceName;
        this.nextInvocations = builder.nextInvocations;
        this.roleArn = builder.roleArn;
        this.schedule = builder.schedule;
        this.scheduledActionDescription = builder.scheduledActionDescription;
        this.scheduledActionName = builder.scheduledActionName;
        this.scheduledActionUuid = builder.scheduledActionUuid;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.targetAction = builder.targetAction;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final boolean hasNextInvocations() {
        return this.nextInvocations != null && !(this.nextInvocations instanceof SdkAutoConstructList);
    }

    public final List<Instant> nextInvocations() {
        return this.nextInvocations;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Schedule schedule() {
        return this.schedule;
    }

    public final String scheduledActionDescription() {
        return this.scheduledActionDescription;
    }

    public final String scheduledActionName() {
        return this.scheduledActionName;
    }

    public final String scheduledActionUuid() {
        return this.scheduledActionUuid;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final State state() {
        return State.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final TargetAction targetAction() {
        return this.targetAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNextInvocations() ? this.nextInvocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionUuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledActionResponse)) {
            return false;
        }
        ScheduledActionResponse other = (ScheduledActionResponse)obj;
        return Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.namespaceName(), other.namespaceName()) && this.hasNextInvocations() == other.hasNextInvocations() && Objects.equals(this.nextInvocations(), other.nextInvocations()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.scheduledActionDescription(), other.scheduledActionDescription()) && Objects.equals(this.scheduledActionName(), other.scheduledActionName()) && Objects.equals(this.scheduledActionUuid(), other.scheduledActionUuid()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.targetAction(), other.targetAction());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledActionResponse").add("EndTime", (Object)this.endTime()).add("NamespaceName", (Object)this.namespaceName()).add("NextInvocations", this.hasNextInvocations() ? this.nextInvocations() : null).add("RoleArn", (Object)this.roleArn()).add("Schedule", (Object)this.schedule()).add("ScheduledActionDescription", (Object)this.scheduledActionDescription()).add("ScheduledActionName", (Object)this.scheduledActionName()).add("ScheduledActionUuid", (Object)this.scheduledActionUuid()).add("StartTime", (Object)this.startTime()).add("State", (Object)this.stateAsString()).add("TargetAction", (Object)this.targetAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "nextInvocations": {
                return Optional.ofNullable(clazz.cast(this.nextInvocations()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "scheduledActionDescription": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionDescription()));
            }
            case "scheduledActionName": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionName()));
            }
            case "scheduledActionUuid": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionUuid()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "targetAction": {
                return Optional.ofNullable(clazz.cast(this.targetAction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledActionResponse, T> g) {
        return obj -> g.apply((ScheduledActionResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant endTime;
        private String namespaceName;
        private List<Instant> nextInvocations = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private Schedule schedule;
        private String scheduledActionDescription;
        private String scheduledActionName;
        private String scheduledActionUuid;
        private Instant startTime;
        private String state;
        private TargetAction targetAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledActionResponse model) {
            this.endTime(model.endTime);
            this.namespaceName(model.namespaceName);
            this.nextInvocations(model.nextInvocations);
            this.roleArn(model.roleArn);
            this.schedule(model.schedule);
            this.scheduledActionDescription(model.scheduledActionDescription);
            this.scheduledActionName(model.scheduledActionName);
            this.scheduledActionUuid(model.scheduledActionUuid);
            this.startTime(model.startTime);
            this.state(model.state);
            this.targetAction(model.targetAction);
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final Collection<Instant> getNextInvocations() {
            if (this.nextInvocations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nextInvocations;
        }

        public final void setNextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = NextInvocationsListCopier.copy(nextInvocations);
        }

        @Override
        public final Builder nextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = NextInvocationsListCopier.copy(nextInvocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextInvocations(Instant ... nextInvocations) {
            this.nextInvocations(Arrays.asList(nextInvocations));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getScheduledActionDescription() {
            return this.scheduledActionDescription;
        }

        public final void setScheduledActionDescription(String scheduledActionDescription) {
            this.scheduledActionDescription = scheduledActionDescription;
        }

        @Override
        public final Builder scheduledActionDescription(String scheduledActionDescription) {
            this.scheduledActionDescription = scheduledActionDescription;
            return this;
        }

        public final String getScheduledActionName() {
            return this.scheduledActionName;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final String getScheduledActionUuid() {
            return this.scheduledActionUuid;
        }

        public final void setScheduledActionUuid(String scheduledActionUuid) {
            this.scheduledActionUuid = scheduledActionUuid;
        }

        @Override
        public final Builder scheduledActionUuid(String scheduledActionUuid) {
            this.scheduledActionUuid = scheduledActionUuid;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final TargetAction.Builder getTargetAction() {
            return this.targetAction != null ? this.targetAction.toBuilder() : null;
        }

        public final void setTargetAction(TargetAction.BuilderImpl targetAction) {
            this.targetAction = targetAction != null ? targetAction.build() : null;
        }

        @Override
        public final Builder targetAction(TargetAction targetAction) {
            this.targetAction = targetAction;
            return this;
        }

        public ScheduledActionResponse build() {
            return new ScheduledActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledActionResponse> {
        public Builder endTime(Instant var1);

        public Builder namespaceName(String var1);

        public Builder nextInvocations(Collection<Instant> var1);

        public Builder nextInvocations(Instant ... var1);

        public Builder roleArn(String var1);

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder scheduledActionDescription(String var1);

        public Builder scheduledActionName(String var1);

        public Builder scheduledActionUuid(String var1);

        public Builder startTime(Instant var1);

        public Builder state(String var1);

        public Builder state(State var1);

        public Builder targetAction(TargetAction var1);

        default public Builder targetAction(Consumer<TargetAction.Builder> targetAction) {
            return this.targetAction((TargetAction)((TargetAction.Builder)TargetAction.builder().applyMutation(targetAction)).build());
        }
    }
}

