/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataResponse;
import software.amazon.awssdk.services.redshiftdata.model.SqlParameter;
import software.amazon.awssdk.services.redshiftdata.model.SqlParametersListCopier;
import software.amazon.awssdk.services.redshiftdata.model.StatusString;
import software.amazon.awssdk.services.redshiftdata.model.SubStatementData;
import software.amazon.awssdk.services.redshiftdata.model.SubStatementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStatementResponse
extends RedshiftDataResponse
implements ToCopyableBuilder<Builder, DescribeStatementResponse> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(DescribeStatementResponse.getter(DescribeStatementResponse::clusterIdentifier)).setter(DescribeStatementResponse.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeStatementResponse.getter(DescribeStatementResponse::createdAt)).setter(DescribeStatementResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(DescribeStatementResponse.getter(DescribeStatementResponse::database)).setter(DescribeStatementResponse.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbUser").getter(DescribeStatementResponse.getter(DescribeStatementResponse::dbUser)).setter(DescribeStatementResponse.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Duration").getter(DescribeStatementResponse.getter(DescribeStatementResponse::duration)).setter(DescribeStatementResponse.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Error").getter(DescribeStatementResponse.getter(DescribeStatementResponse::error)).setter(DescribeStatementResponse.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<Boolean> HAS_RESULT_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HasResultSet").getter(DescribeStatementResponse.getter(DescribeStatementResponse::hasResultSet)).setter(DescribeStatementResponse.setter(Builder::hasResultSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasResultSet").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DescribeStatementResponse.getter(DescribeStatementResponse::id)).setter(DescribeStatementResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<List<SqlParameter>> QUERY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryParameters").getter(DescribeStatementResponse.getter(DescribeStatementResponse::queryParameters)).setter(DescribeStatementResponse.setter(Builder::queryParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SqlParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(DescribeStatementResponse.getter(DescribeStatementResponse::queryString)).setter(DescribeStatementResponse.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<Long> REDSHIFT_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RedshiftPid").getter(DescribeStatementResponse.getter(DescribeStatementResponse::redshiftPid)).setter(DescribeStatementResponse.setter(Builder::redshiftPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftPid").build()}).build();
    private static final SdkField<Long> REDSHIFT_QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RedshiftQueryId").getter(DescribeStatementResponse.getter(DescribeStatementResponse::redshiftQueryId)).setter(DescribeStatementResponse.setter(Builder::redshiftQueryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftQueryId").build()}).build();
    private static final SdkField<Long> RESULT_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ResultRows").getter(DescribeStatementResponse.getter(DescribeStatementResponse::resultRows)).setter(DescribeStatementResponse.setter(Builder::resultRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultRows").build()}).build();
    private static final SdkField<Long> RESULT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ResultSize").getter(DescribeStatementResponse.getter(DescribeStatementResponse::resultSize)).setter(DescribeStatementResponse.setter(Builder::resultSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultSize").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(DescribeStatementResponse.getter(DescribeStatementResponse::secretArn)).setter(DescribeStatementResponse.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeStatementResponse.getter(DescribeStatementResponse::statusAsString)).setter(DescribeStatementResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<SubStatementData>> SUB_STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubStatements").getter(DescribeStatementResponse.getter(DescribeStatementResponse::subStatements)).setter(DescribeStatementResponse.setter(Builder::subStatements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubStatements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubStatementData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(DescribeStatementResponse.getter(DescribeStatementResponse::updatedAt)).setter(DescribeStatementResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, CREATED_AT_FIELD, DATABASE_FIELD, DB_USER_FIELD, DURATION_FIELD, ERROR_FIELD, HAS_RESULT_SET_FIELD, ID_FIELD, QUERY_PARAMETERS_FIELD, QUERY_STRING_FIELD, REDSHIFT_PID_FIELD, REDSHIFT_QUERY_ID_FIELD, RESULT_ROWS_FIELD, RESULT_SIZE_FIELD, SECRET_ARN_FIELD, STATUS_FIELD, SUB_STATEMENTS_FIELD, UPDATED_AT_FIELD));
    private final String clusterIdentifier;
    private final Instant createdAt;
    private final String database;
    private final String dbUser;
    private final Long duration;
    private final String error;
    private final Boolean hasResultSet;
    private final String id;
    private final List<SqlParameter> queryParameters;
    private final String queryString;
    private final Long redshiftPid;
    private final Long redshiftQueryId;
    private final Long resultRows;
    private final Long resultSize;
    private final String secretArn;
    private final String status;
    private final List<SubStatementData> subStatements;
    private final Instant updatedAt;

    private DescribeStatementResponse(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.createdAt = builder.createdAt;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.duration = builder.duration;
        this.error = builder.error;
        this.hasResultSet = builder.hasResultSet;
        this.id = builder.id;
        this.queryParameters = builder.queryParameters;
        this.queryString = builder.queryString;
        this.redshiftPid = builder.redshiftPid;
        this.redshiftQueryId = builder.redshiftQueryId;
        this.resultRows = builder.resultRows;
        this.resultSize = builder.resultSize;
        this.secretArn = builder.secretArn;
        this.status = builder.status;
        this.subStatements = builder.subStatements;
        this.updatedAt = builder.updatedAt;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String database() {
        return this.database;
    }

    public final String dbUser() {
        return this.dbUser;
    }

    public final Long duration() {
        return this.duration;
    }

    public final String error() {
        return this.error;
    }

    public final Boolean hasResultSet() {
        return this.hasResultSet;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasQueryParameters() {
        return this.queryParameters != null && !(this.queryParameters instanceof SdkAutoConstructList);
    }

    public final List<SqlParameter> queryParameters() {
        return this.queryParameters;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final Long redshiftPid() {
        return this.redshiftPid;
    }

    public final Long redshiftQueryId() {
        return this.redshiftQueryId;
    }

    public final Long resultRows() {
        return this.resultRows;
    }

    public final Long resultSize() {
        return this.resultSize;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final StatusString status() {
        return StatusString.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasSubStatements() {
        return this.subStatements != null && !(this.subStatements instanceof SdkAutoConstructList);
    }

    public final List<SubStatementData> subStatements() {
        return this.subStatements;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryParameters() ? this.queryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftQueryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultRows());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubStatements() ? this.subStatements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStatementResponse)) {
            return false;
        }
        DescribeStatementResponse other = (DescribeStatementResponse)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.hasResultSet(), other.hasResultSet()) && Objects.equals(this.id(), other.id()) && this.hasQueryParameters() == other.hasQueryParameters() && Objects.equals(this.queryParameters(), other.queryParameters()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.redshiftPid(), other.redshiftPid()) && Objects.equals(this.redshiftQueryId(), other.redshiftQueryId()) && Objects.equals(this.resultRows(), other.resultRows()) && Objects.equals(this.resultSize(), other.resultSize()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasSubStatements() == other.hasSubStatements() && Objects.equals(this.subStatements(), other.subStatements()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStatementResponse").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("CreatedAt", (Object)this.createdAt()).add("Database", (Object)this.database()).add("DbUser", (Object)this.dbUser()).add("Duration", (Object)this.duration()).add("Error", (Object)this.error()).add("HasResultSet", (Object)this.hasResultSet()).add("Id", (Object)this.id()).add("QueryParameters", this.hasQueryParameters() ? this.queryParameters() : null).add("QueryString", (Object)this.queryString()).add("RedshiftPid", (Object)this.redshiftPid()).add("RedshiftQueryId", (Object)this.redshiftQueryId()).add("ResultRows", (Object)this.resultRows()).add("ResultSize", (Object)this.resultSize()).add("SecretArn", (Object)this.secretArn()).add("Status", (Object)this.statusAsString()).add("SubStatements", this.hasSubStatements() ? this.subStatements() : null).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "HasResultSet": {
                return Optional.ofNullable(clazz.cast(this.hasResultSet()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "QueryParameters": {
                return Optional.ofNullable(clazz.cast(this.queryParameters()));
            }
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "RedshiftPid": {
                return Optional.ofNullable(clazz.cast(this.redshiftPid()));
            }
            case "RedshiftQueryId": {
                return Optional.ofNullable(clazz.cast(this.redshiftQueryId()));
            }
            case "ResultRows": {
                return Optional.ofNullable(clazz.cast(this.resultRows()));
            }
            case "ResultSize": {
                return Optional.ofNullable(clazz.cast(this.resultSize()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SubStatements": {
                return Optional.ofNullable(clazz.cast(this.subStatements()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStatementResponse, T> g) {
        return obj -> g.apply((DescribeStatementResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftDataResponse.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private Instant createdAt;
        private String database;
        private String dbUser;
        private Long duration;
        private String error;
        private Boolean hasResultSet;
        private String id;
        private List<SqlParameter> queryParameters = DefaultSdkAutoConstructList.getInstance();
        private String queryString;
        private Long redshiftPid;
        private Long redshiftQueryId;
        private Long resultRows;
        private Long resultSize;
        private String secretArn;
        private String status;
        private List<SubStatementData> subStatements = DefaultSdkAutoConstructList.getInstance();
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStatementResponse model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.createdAt(model.createdAt);
            this.database(model.database);
            this.dbUser(model.dbUser);
            this.duration(model.duration);
            this.error(model.error);
            this.hasResultSet(model.hasResultSet);
            this.id(model.id);
            this.queryParameters(model.queryParameters);
            this.queryString(model.queryString);
            this.redshiftPid(model.redshiftPid);
            this.redshiftQueryId(model.redshiftQueryId);
            this.resultRows(model.resultRows);
            this.resultSize(model.resultSize);
            this.secretArn(model.secretArn);
            this.status(model.status);
            this.subStatements(model.subStatements);
            this.updatedAt(model.updatedAt);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        @Transient
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        @Transient
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        @Transient
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final Long getDuration() {
            return this.duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        @Transient
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        @Transient
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final Boolean getHasResultSet() {
            return this.hasResultSet;
        }

        public final void setHasResultSet(Boolean hasResultSet) {
            this.hasResultSet = hasResultSet;
        }

        @Override
        @Transient
        public final Builder hasResultSet(Boolean hasResultSet) {
            this.hasResultSet = hasResultSet;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<SqlParameter.Builder> getQueryParameters() {
            List<SqlParameter.Builder> result = SqlParametersListCopier.copyToBuilder(this.queryParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryParameters(Collection<SqlParameter.BuilderImpl> queryParameters) {
            this.queryParameters = SqlParametersListCopier.copyFromBuilder(queryParameters);
        }

        @Override
        @Transient
        public final Builder queryParameters(Collection<SqlParameter> queryParameters) {
            this.queryParameters = SqlParametersListCopier.copy(queryParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder queryParameters(SqlParameter ... queryParameters) {
            this.queryParameters(Arrays.asList(queryParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder queryParameters(Consumer<SqlParameter.Builder> ... queryParameters) {
            this.queryParameters(Stream.of(queryParameters).map(c -> (SqlParameter)((SqlParameter.Builder)SqlParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        @Transient
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Long getRedshiftPid() {
            return this.redshiftPid;
        }

        public final void setRedshiftPid(Long redshiftPid) {
            this.redshiftPid = redshiftPid;
        }

        @Override
        @Transient
        public final Builder redshiftPid(Long redshiftPid) {
            this.redshiftPid = redshiftPid;
            return this;
        }

        public final Long getRedshiftQueryId() {
            return this.redshiftQueryId;
        }

        public final void setRedshiftQueryId(Long redshiftQueryId) {
            this.redshiftQueryId = redshiftQueryId;
        }

        @Override
        @Transient
        public final Builder redshiftQueryId(Long redshiftQueryId) {
            this.redshiftQueryId = redshiftQueryId;
            return this;
        }

        public final Long getResultRows() {
            return this.resultRows;
        }

        public final void setResultRows(Long resultRows) {
            this.resultRows = resultRows;
        }

        @Override
        @Transient
        public final Builder resultRows(Long resultRows) {
            this.resultRows = resultRows;
            return this;
        }

        public final Long getResultSize() {
            return this.resultSize;
        }

        public final void setResultSize(Long resultSize) {
            this.resultSize = resultSize;
        }

        @Override
        @Transient
        public final Builder resultSize(Long resultSize) {
            this.resultSize = resultSize;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        @Transient
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(StatusString status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<SubStatementData.Builder> getSubStatements() {
            List<SubStatementData.Builder> result = SubStatementListCopier.copyToBuilder(this.subStatements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubStatements(Collection<SubStatementData.BuilderImpl> subStatements) {
            this.subStatements = SubStatementListCopier.copyFromBuilder(subStatements);
        }

        @Override
        @Transient
        public final Builder subStatements(Collection<SubStatementData> subStatements) {
            this.subStatements = SubStatementListCopier.copy(subStatements);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subStatements(SubStatementData ... subStatements) {
            this.subStatements(Arrays.asList(subStatements));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subStatements(Consumer<SubStatementData.Builder> ... subStatements) {
            this.subStatements(Stream.of(subStatements).map(c -> (SubStatementData)((SubStatementData.Builder)SubStatementData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public DescribeStatementResponse build() {
            return new DescribeStatementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStatementResponse> {
        public Builder clusterIdentifier(String var1);

        public Builder createdAt(Instant var1);

        public Builder database(String var1);

        public Builder dbUser(String var1);

        public Builder duration(Long var1);

        public Builder error(String var1);

        public Builder hasResultSet(Boolean var1);

        public Builder id(String var1);

        public Builder queryParameters(Collection<SqlParameter> var1);

        public Builder queryParameters(SqlParameter ... var1);

        public Builder queryParameters(Consumer<SqlParameter.Builder> ... var1);

        public Builder queryString(String var1);

        public Builder redshiftPid(Long var1);

        public Builder redshiftQueryId(Long var1);

        public Builder resultRows(Long var1);

        public Builder resultSize(Long var1);

        public Builder secretArn(String var1);

        public Builder status(String var1);

        public Builder status(StatusString var1);

        public Builder subStatements(Collection<SubStatementData> var1);

        public Builder subStatements(SubStatementData ... var1);

        public Builder subStatements(Consumer<SubStatementData.Builder> ... var1);

        public Builder updatedAt(Instant var1);
    }
}

