/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotMessage;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotMessageListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteClusterSnapshotsRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, BatchDeleteClusterSnapshotsRequest> {
    private static final SdkField<List<DeleteClusterSnapshotMessage>> IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDeleteClusterSnapshotsRequest.getter(BatchDeleteClusterSnapshotsRequest::identifiers)).setter(BatchDeleteClusterSnapshotsRequest.setter(Builder::identifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifiers").build(), ListTrait.builder().memberLocationName("DeleteClusterSnapshotMessage").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteClusterSnapshotMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteClusterSnapshotMessage").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIERS_FIELD));
    private final List<DeleteClusterSnapshotMessage> identifiers;

    private BatchDeleteClusterSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.identifiers = builder.identifiers;
    }

    public List<DeleteClusterSnapshotMessage> identifiers() {
        return this.identifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifiers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteClusterSnapshotsRequest)) {
            return false;
        }
        BatchDeleteClusterSnapshotsRequest other = (BatchDeleteClusterSnapshotsRequest)((Object)obj);
        return Objects.equals(this.identifiers(), other.identifiers());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteClusterSnapshotsRequest").add("Identifiers", this.identifiers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifiers": {
                return Optional.ofNullable(clazz.cast(this.identifiers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteClusterSnapshotsRequest, T> g) {
        return obj -> g.apply((BatchDeleteClusterSnapshotsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private List<DeleteClusterSnapshotMessage> identifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteClusterSnapshotsRequest model) {
            super(model);
            this.identifiers(model.identifiers);
        }

        public final Collection<DeleteClusterSnapshotMessage.Builder> getIdentifiers() {
            return this.identifiers != null ? (Collection)this.identifiers.stream().map(DeleteClusterSnapshotMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder identifiers(Collection<DeleteClusterSnapshotMessage> identifiers) {
            this.identifiers = DeleteClusterSnapshotMessageListCopier.copy(identifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(DeleteClusterSnapshotMessage ... identifiers) {
            this.identifiers(Arrays.asList(identifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(Consumer<DeleteClusterSnapshotMessage.Builder> ... identifiers) {
            this.identifiers(Stream.of(identifiers).map(c -> (DeleteClusterSnapshotMessage)((DeleteClusterSnapshotMessage.Builder)DeleteClusterSnapshotMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIdentifiers(Collection<DeleteClusterSnapshotMessage.BuilderImpl> identifiers) {
            this.identifiers = DeleteClusterSnapshotMessageListCopier.copyFromBuilder(identifiers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteClusterSnapshotsRequest build() {
            return new BatchDeleteClusterSnapshotsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteClusterSnapshotsRequest> {
        public Builder identifiers(Collection<DeleteClusterSnapshotMessage> var1);

        public Builder identifiers(DeleteClusterSnapshotMessage ... var1);

        public Builder identifiers(Consumer<DeleteClusterSnapshotMessage.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

