/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataTransferProgress
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataTransferProgress> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DataTransferProgress.getter(DataTransferProgress::status)).setter(DataTransferProgress.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Double> CURRENT_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("CurrentRateInMegaBytesPerSecond").getter(DataTransferProgress.getter(DataTransferProgress::currentRateInMegaBytesPerSecond)).setter(DataTransferProgress.setter(Builder::currentRateInMegaBytesPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentRateInMegaBytesPerSecond").build()}).build();
    private static final SdkField<Long> TOTAL_DATA_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalDataInMegaBytes").getter(DataTransferProgress.getter(DataTransferProgress::totalDataInMegaBytes)).setter(DataTransferProgress.setter(Builder::totalDataInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalDataInMegaBytes").build()}).build();
    private static final SdkField<Long> DATA_TRANSFERRED_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DataTransferredInMegaBytes").getter(DataTransferProgress.getter(DataTransferProgress::dataTransferredInMegaBytes)).setter(DataTransferProgress.setter(Builder::dataTransferredInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferredInMegaBytes").build()}).build();
    private static final SdkField<Long> ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedTimeToCompletionInSeconds").getter(DataTransferProgress.getter(DataTransferProgress::estimatedTimeToCompletionInSeconds)).setter(DataTransferProgress.setter(Builder::estimatedTimeToCompletionInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeToCompletionInSeconds").build()}).build();
    private static final SdkField<Long> ELAPSED_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ElapsedTimeInSeconds").getter(DataTransferProgress.getter(DataTransferProgress::elapsedTimeInSeconds)).setter(DataTransferProgress.setter(Builder::elapsedTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CURRENT_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD, TOTAL_DATA_IN_MEGA_BYTES_FIELD, DATA_TRANSFERRED_IN_MEGA_BYTES_FIELD, ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD, ELAPSED_TIME_IN_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataTransferProgress.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Double currentRateInMegaBytesPerSecond;
    private final Long totalDataInMegaBytes;
    private final Long dataTransferredInMegaBytes;
    private final Long estimatedTimeToCompletionInSeconds;
    private final Long elapsedTimeInSeconds;

    private DataTransferProgress(BuilderImpl builder) {
        this.status = builder.status;
        this.currentRateInMegaBytesPerSecond = builder.currentRateInMegaBytesPerSecond;
        this.totalDataInMegaBytes = builder.totalDataInMegaBytes;
        this.dataTransferredInMegaBytes = builder.dataTransferredInMegaBytes;
        this.estimatedTimeToCompletionInSeconds = builder.estimatedTimeToCompletionInSeconds;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
    }

    public final String status() {
        return this.status;
    }

    public final Double currentRateInMegaBytesPerSecond() {
        return this.currentRateInMegaBytesPerSecond;
    }

    public final Long totalDataInMegaBytes() {
        return this.totalDataInMegaBytes;
    }

    public final Long dataTransferredInMegaBytes() {
        return this.dataTransferredInMegaBytes;
    }

    public final Long estimatedTimeToCompletionInSeconds() {
        return this.estimatedTimeToCompletionInSeconds;
    }

    public final Long elapsedTimeInSeconds() {
        return this.elapsedTimeInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalDataInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTransferredInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTimeToCompletionInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.elapsedTimeInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTransferProgress)) {
            return false;
        }
        DataTransferProgress other = (DataTransferProgress)obj;
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.currentRateInMegaBytesPerSecond(), other.currentRateInMegaBytesPerSecond()) && Objects.equals(this.totalDataInMegaBytes(), other.totalDataInMegaBytes()) && Objects.equals(this.dataTransferredInMegaBytes(), other.dataTransferredInMegaBytes()) && Objects.equals(this.estimatedTimeToCompletionInSeconds(), other.estimatedTimeToCompletionInSeconds()) && Objects.equals(this.elapsedTimeInSeconds(), other.elapsedTimeInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"DataTransferProgress").add("Status", (Object)this.status()).add("CurrentRateInMegaBytesPerSecond", (Object)this.currentRateInMegaBytesPerSecond()).add("TotalDataInMegaBytes", (Object)this.totalDataInMegaBytes()).add("DataTransferredInMegaBytes", (Object)this.dataTransferredInMegaBytes()).add("EstimatedTimeToCompletionInSeconds", (Object)this.estimatedTimeToCompletionInSeconds()).add("ElapsedTimeInSeconds", (Object)this.elapsedTimeInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CurrentRateInMegaBytesPerSecond": {
                return Optional.ofNullable(clazz.cast(this.currentRateInMegaBytesPerSecond()));
            }
            case "TotalDataInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.totalDataInMegaBytes()));
            }
            case "DataTransferredInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.dataTransferredInMegaBytes()));
            }
            case "EstimatedTimeToCompletionInSeconds": {
                return Optional.ofNullable(clazz.cast(this.estimatedTimeToCompletionInSeconds()));
            }
            case "ElapsedTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.elapsedTimeInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("CurrentRateInMegaBytesPerSecond", CURRENT_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD);
        map.put("TotalDataInMegaBytes", TOTAL_DATA_IN_MEGA_BYTES_FIELD);
        map.put("DataTransferredInMegaBytes", DATA_TRANSFERRED_IN_MEGA_BYTES_FIELD);
        map.put("EstimatedTimeToCompletionInSeconds", ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD);
        map.put("ElapsedTimeInSeconds", ELAPSED_TIME_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataTransferProgress, T> g) {
        return obj -> g.apply((DataTransferProgress)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Double currentRateInMegaBytesPerSecond;
        private Long totalDataInMegaBytes;
        private Long dataTransferredInMegaBytes;
        private Long estimatedTimeToCompletionInSeconds;
        private Long elapsedTimeInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTransferProgress model) {
            this.status(model.status);
            this.currentRateInMegaBytesPerSecond(model.currentRateInMegaBytesPerSecond);
            this.totalDataInMegaBytes(model.totalDataInMegaBytes);
            this.dataTransferredInMegaBytes(model.dataTransferredInMegaBytes);
            this.estimatedTimeToCompletionInSeconds(model.estimatedTimeToCompletionInSeconds);
            this.elapsedTimeInSeconds(model.elapsedTimeInSeconds);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Double getCurrentRateInMegaBytesPerSecond() {
            return this.currentRateInMegaBytesPerSecond;
        }

        public final void setCurrentRateInMegaBytesPerSecond(Double currentRateInMegaBytesPerSecond) {
            this.currentRateInMegaBytesPerSecond = currentRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder currentRateInMegaBytesPerSecond(Double currentRateInMegaBytesPerSecond) {
            this.currentRateInMegaBytesPerSecond = currentRateInMegaBytesPerSecond;
            return this;
        }

        public final Long getTotalDataInMegaBytes() {
            return this.totalDataInMegaBytes;
        }

        public final void setTotalDataInMegaBytes(Long totalDataInMegaBytes) {
            this.totalDataInMegaBytes = totalDataInMegaBytes;
        }

        @Override
        public final Builder totalDataInMegaBytes(Long totalDataInMegaBytes) {
            this.totalDataInMegaBytes = totalDataInMegaBytes;
            return this;
        }

        public final Long getDataTransferredInMegaBytes() {
            return this.dataTransferredInMegaBytes;
        }

        public final void setDataTransferredInMegaBytes(Long dataTransferredInMegaBytes) {
            this.dataTransferredInMegaBytes = dataTransferredInMegaBytes;
        }

        @Override
        public final Builder dataTransferredInMegaBytes(Long dataTransferredInMegaBytes) {
            this.dataTransferredInMegaBytes = dataTransferredInMegaBytes;
            return this;
        }

        public final Long getEstimatedTimeToCompletionInSeconds() {
            return this.estimatedTimeToCompletionInSeconds;
        }

        public final void setEstimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
        }

        @Override
        public final Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
            return this;
        }

        public final Long getElapsedTimeInSeconds() {
            return this.elapsedTimeInSeconds;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public DataTransferProgress build() {
            return new DataTransferProgress(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataTransferProgress> {
        public Builder status(String var1);

        public Builder currentRateInMegaBytesPerSecond(Double var1);

        public Builder totalDataInMegaBytes(Long var1);

        public Builder dataTransferredInMegaBytes(Long var1);

        public Builder estimatedTimeToCompletionInSeconds(Long var1);

        public Builder elapsedTimeInSeconds(Long var1);
    }
}

