/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.NodeConfigurationOption;
import software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNodeConfigurationOptionsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeNodeConfigurationOptionsResponse> {
    private static final SdkField<List<NodeConfigurationOption>> NODE_CONFIGURATION_OPTION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeConfigurationOptionList").getter(DescribeNodeConfigurationOptionsResponse.getter(DescribeNodeConfigurationOptionsResponse::nodeConfigurationOptionList)).setter(DescribeNodeConfigurationOptionsResponse.setter(Builder::nodeConfigurationOptionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeConfigurationOptionList").build(), ListTrait.builder().memberLocationName("NodeConfigurationOption").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeConfigurationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeConfigurationOption").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeNodeConfigurationOptionsResponse.getter(DescribeNodeConfigurationOptionsResponse::marker)).setter(DescribeNodeConfigurationOptionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_CONFIGURATION_OPTION_LIST_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeNodeConfigurationOptionsResponse.memberNameToFieldInitializer();
    private final List<NodeConfigurationOption> nodeConfigurationOptionList;
    private final String marker;

    private DescribeNodeConfigurationOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.nodeConfigurationOptionList = builder.nodeConfigurationOptionList;
        this.marker = builder.marker;
    }

    public final boolean hasNodeConfigurationOptionList() {
        return this.nodeConfigurationOptionList != null && !(this.nodeConfigurationOptionList instanceof SdkAutoConstructList);
    }

    public final List<NodeConfigurationOption> nodeConfigurationOptionList() {
        return this.nodeConfigurationOptionList;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeConfigurationOptionList() ? this.nodeConfigurationOptionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeConfigurationOptionsResponse)) {
            return false;
        }
        DescribeNodeConfigurationOptionsResponse other = (DescribeNodeConfigurationOptionsResponse)((Object)obj);
        return this.hasNodeConfigurationOptionList() == other.hasNodeConfigurationOptionList() && Objects.equals(this.nodeConfigurationOptionList(), other.nodeConfigurationOptionList()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNodeConfigurationOptionsResponse").add("NodeConfigurationOptionList", this.hasNodeConfigurationOptionList() ? this.nodeConfigurationOptionList() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeConfigurationOptionList": {
                return Optional.ofNullable(clazz.cast(this.nodeConfigurationOptionList()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NodeConfigurationOptionList", NODE_CONFIGURATION_OPTION_LIST_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeNodeConfigurationOptionsResponse, T> g) {
        return obj -> g.apply((DescribeNodeConfigurationOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<NodeConfigurationOption> nodeConfigurationOptionList = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeConfigurationOptionsResponse model) {
            super(model);
            this.nodeConfigurationOptionList(model.nodeConfigurationOptionList);
            this.marker(model.marker);
        }

        public final List<NodeConfigurationOption.Builder> getNodeConfigurationOptionList() {
            List<NodeConfigurationOption.Builder> result = NodeConfigurationOptionListCopier.copyToBuilder(this.nodeConfigurationOptionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeConfigurationOptionList(Collection<NodeConfigurationOption.BuilderImpl> nodeConfigurationOptionList) {
            this.nodeConfigurationOptionList = NodeConfigurationOptionListCopier.copyFromBuilder(nodeConfigurationOptionList);
        }

        @Override
        public final Builder nodeConfigurationOptionList(Collection<NodeConfigurationOption> nodeConfigurationOptionList) {
            this.nodeConfigurationOptionList = NodeConfigurationOptionListCopier.copy(nodeConfigurationOptionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeConfigurationOptionList(NodeConfigurationOption ... nodeConfigurationOptionList) {
            this.nodeConfigurationOptionList(Arrays.asList(nodeConfigurationOptionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeConfigurationOptionList(Consumer<NodeConfigurationOption.Builder> ... nodeConfigurationOptionList) {
            this.nodeConfigurationOptionList(Stream.of(nodeConfigurationOptionList).map(c -> (NodeConfigurationOption)((NodeConfigurationOption.Builder)NodeConfigurationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeNodeConfigurationOptionsResponse build() {
            return new DescribeNodeConfigurationOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNodeConfigurationOptionsResponse> {
        public Builder nodeConfigurationOptionList(Collection<NodeConfigurationOption> var1);

        public Builder nodeConfigurationOptionList(NodeConfigurationOption ... var1);

        public Builder nodeConfigurationOptionList(Consumer<NodeConfigurationOption.Builder> ... var1);

        public Builder marker(String var1);
    }
}

