/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterVersion> {
    private static final SdkField<String> CLUSTER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterVersion").getter(ClusterVersion.getter(ClusterVersion::clusterVersion)).setter(ClusterVersion.setter(Builder::clusterVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterVersion").build()}).build();
    private static final SdkField<String> CLUSTER_PARAMETER_GROUP_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterParameterGroupFamily").getter(ClusterVersion.getter(ClusterVersion::clusterParameterGroupFamily)).setter(ClusterVersion.setter(Builder::clusterParameterGroupFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterGroupFamily").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ClusterVersion.getter(ClusterVersion::description)).setter(ClusterVersion.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_VERSION_FIELD, CLUSTER_PARAMETER_GROUP_FAMILY_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterVersion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterVersion;
    private final String clusterParameterGroupFamily;
    private final String description;

    private ClusterVersion(BuilderImpl builder) {
        this.clusterVersion = builder.clusterVersion;
        this.clusterParameterGroupFamily = builder.clusterParameterGroupFamily;
        this.description = builder.description;
    }

    public final String clusterVersion() {
        return this.clusterVersion;
    }

    public final String clusterParameterGroupFamily() {
        return this.clusterParameterGroupFamily;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterVersion)) {
            return false;
        }
        ClusterVersion other = (ClusterVersion)obj;
        return Objects.equals(this.clusterVersion(), other.clusterVersion()) && Objects.equals(this.clusterParameterGroupFamily(), other.clusterParameterGroupFamily()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterVersion").add("ClusterVersion", (Object)this.clusterVersion()).add("ClusterParameterGroupFamily", (Object)this.clusterParameterGroupFamily()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterVersion": {
                return Optional.ofNullable(clazz.cast(this.clusterVersion()));
            }
            case "ClusterParameterGroupFamily": {
                return Optional.ofNullable(clazz.cast(this.clusterParameterGroupFamily()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ClusterVersion", CLUSTER_VERSION_FIELD);
        map.put("ClusterParameterGroupFamily", CLUSTER_PARAMETER_GROUP_FAMILY_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterVersion, T> g) {
        return obj -> g.apply((ClusterVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterVersion;
        private String clusterParameterGroupFamily;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterVersion model) {
            this.clusterVersion(model.clusterVersion);
            this.clusterParameterGroupFamily(model.clusterParameterGroupFamily);
            this.description(model.description);
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final String getClusterParameterGroupFamily() {
            return this.clusterParameterGroupFamily;
        }

        public final void setClusterParameterGroupFamily(String clusterParameterGroupFamily) {
            this.clusterParameterGroupFamily = clusterParameterGroupFamily;
        }

        @Override
        public final Builder clusterParameterGroupFamily(String clusterParameterGroupFamily) {
            this.clusterParameterGroupFamily = clusterParameterGroupFamily;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public ClusterVersion build() {
            return new ClusterVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterVersion> {
        public Builder clusterVersion(String var1);

        public Builder clusterParameterGroupFamily(String var1);

        public Builder description(String var1);
    }
}

