/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftIdcApplication;
import software.amazon.awssdk.services.redshift.model.RedshiftIdcApplicationListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRedshiftIdcApplicationsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeRedshiftIdcApplicationsResponse> {
    private static final SdkField<List<RedshiftIdcApplication>> REDSHIFT_IDC_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RedshiftIdcApplications").getter(DescribeRedshiftIdcApplicationsResponse.getter(DescribeRedshiftIdcApplicationsResponse::redshiftIdcApplications)).setter(DescribeRedshiftIdcApplicationsResponse.setter(Builder::redshiftIdcApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftIdcApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RedshiftIdcApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeRedshiftIdcApplicationsResponse.getter(DescribeRedshiftIdcApplicationsResponse::marker)).setter(DescribeRedshiftIdcApplicationsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDSHIFT_IDC_APPLICATIONS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRedshiftIdcApplicationsResponse.memberNameToFieldInitializer();
    private final List<RedshiftIdcApplication> redshiftIdcApplications;
    private final String marker;

    private DescribeRedshiftIdcApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.redshiftIdcApplications = builder.redshiftIdcApplications;
        this.marker = builder.marker;
    }

    public final boolean hasRedshiftIdcApplications() {
        return this.redshiftIdcApplications != null && !(this.redshiftIdcApplications instanceof SdkAutoConstructList);
    }

    public final List<RedshiftIdcApplication> redshiftIdcApplications() {
        return this.redshiftIdcApplications;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRedshiftIdcApplications() ? this.redshiftIdcApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRedshiftIdcApplicationsResponse)) {
            return false;
        }
        DescribeRedshiftIdcApplicationsResponse other = (DescribeRedshiftIdcApplicationsResponse)((Object)obj);
        return this.hasRedshiftIdcApplications() == other.hasRedshiftIdcApplications() && Objects.equals(this.redshiftIdcApplications(), other.redshiftIdcApplications()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRedshiftIdcApplicationsResponse").add("RedshiftIdcApplications", this.hasRedshiftIdcApplications() ? this.redshiftIdcApplications() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RedshiftIdcApplications": {
                return Optional.ofNullable(clazz.cast(this.redshiftIdcApplications()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RedshiftIdcApplications", REDSHIFT_IDC_APPLICATIONS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRedshiftIdcApplicationsResponse, T> g) {
        return obj -> g.apply((DescribeRedshiftIdcApplicationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<RedshiftIdcApplication> redshiftIdcApplications = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRedshiftIdcApplicationsResponse model) {
            super(model);
            this.redshiftIdcApplications(model.redshiftIdcApplications);
            this.marker(model.marker);
        }

        public final List<RedshiftIdcApplication.Builder> getRedshiftIdcApplications() {
            List<RedshiftIdcApplication.Builder> result = RedshiftIdcApplicationListCopier.copyToBuilder(this.redshiftIdcApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRedshiftIdcApplications(Collection<RedshiftIdcApplication.BuilderImpl> redshiftIdcApplications) {
            this.redshiftIdcApplications = RedshiftIdcApplicationListCopier.copyFromBuilder(redshiftIdcApplications);
        }

        @Override
        public final Builder redshiftIdcApplications(Collection<RedshiftIdcApplication> redshiftIdcApplications) {
            this.redshiftIdcApplications = RedshiftIdcApplicationListCopier.copy(redshiftIdcApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redshiftIdcApplications(RedshiftIdcApplication ... redshiftIdcApplications) {
            this.redshiftIdcApplications(Arrays.asList(redshiftIdcApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redshiftIdcApplications(Consumer<RedshiftIdcApplication.Builder> ... redshiftIdcApplications) {
            this.redshiftIdcApplications(Stream.of(redshiftIdcApplications).map(c -> (RedshiftIdcApplication)((RedshiftIdcApplication.Builder)RedshiftIdcApplication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeRedshiftIdcApplicationsResponse build() {
            return new DescribeRedshiftIdcApplicationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRedshiftIdcApplicationsResponse> {
        public Builder redshiftIdcApplications(Collection<RedshiftIdcApplication> var1);

        public Builder redshiftIdcApplications(RedshiftIdcApplication ... var1);

        public Builder redshiftIdcApplications(Consumer<RedshiftIdcApplication.Builder> ... var1);

        public Builder marker(String var1);
    }
}

