/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse;
import software.amazon.awssdk.services.redshift.model.SnapshotSchedule;

public class DescribeSnapshotSchedulesIterable
implements SdkIterable<DescribeSnapshotSchedulesResponse> {
    private final RedshiftClient client;
    private final DescribeSnapshotSchedulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSnapshotSchedulesIterable(RedshiftClient client, DescribeSnapshotSchedulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSnapshotSchedulesResponseFetcher();
    }

    public Iterator<DescribeSnapshotSchedulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SnapshotSchedule> snapshotSchedules() {
        Function<DescribeSnapshotSchedulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshotSchedules() != null) {
                return response.snapshotSchedules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSnapshotSchedulesResponseFetcher
    implements SyncPageFetcher<DescribeSnapshotSchedulesResponse> {
        private DescribeSnapshotSchedulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSnapshotSchedulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeSnapshotSchedulesResponse nextPage(DescribeSnapshotSchedulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeSnapshotSchedulesIterable.this.client.describeSnapshotSchedules(DescribeSnapshotSchedulesIterable.this.firstRequest);
            }
            return DescribeSnapshotSchedulesIterable.this.client.describeSnapshotSchedules((DescribeSnapshotSchedulesRequest)((Object)DescribeSnapshotSchedulesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

