/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerlessIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerlessIdentifier> {
    private static final SdkField<String> NAMESPACE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NamespaceIdentifier").getter(ServerlessIdentifier.getter(ServerlessIdentifier::namespaceIdentifier)).setter(ServerlessIdentifier.setter(Builder::namespaceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceIdentifier").build()}).build();
    private static final SdkField<String> WORKGROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkgroupIdentifier").getter(ServerlessIdentifier.getter(ServerlessIdentifier::workgroupIdentifier)).setter(ServerlessIdentifier.setter(Builder::workgroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkgroupIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_IDENTIFIER_FIELD, WORKGROUP_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NamespaceIdentifier", NAMESPACE_IDENTIFIER_FIELD);
            this.put("WorkgroupIdentifier", WORKGROUP_IDENTIFIER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String namespaceIdentifier;
    private final String workgroupIdentifier;

    private ServerlessIdentifier(BuilderImpl builder) {
        this.namespaceIdentifier = builder.namespaceIdentifier;
        this.workgroupIdentifier = builder.workgroupIdentifier;
    }

    public final String namespaceIdentifier() {
        return this.namespaceIdentifier;
    }

    public final String workgroupIdentifier() {
        return this.workgroupIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessIdentifier)) {
            return false;
        }
        ServerlessIdentifier other = (ServerlessIdentifier)obj;
        return Objects.equals(this.namespaceIdentifier(), other.namespaceIdentifier()) && Objects.equals(this.workgroupIdentifier(), other.workgroupIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ServerlessIdentifier").add("NamespaceIdentifier", (Object)this.namespaceIdentifier()).add("WorkgroupIdentifier", (Object)this.workgroupIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamespaceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.namespaceIdentifier()));
            }
            case "WorkgroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.workgroupIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServerlessIdentifier, T> g) {
        return obj -> g.apply((ServerlessIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespaceIdentifier;
        private String workgroupIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessIdentifier model) {
            this.namespaceIdentifier(model.namespaceIdentifier);
            this.workgroupIdentifier(model.workgroupIdentifier);
        }

        public final String getNamespaceIdentifier() {
            return this.namespaceIdentifier;
        }

        public final void setNamespaceIdentifier(String namespaceIdentifier) {
            this.namespaceIdentifier = namespaceIdentifier;
        }

        @Override
        public final Builder namespaceIdentifier(String namespaceIdentifier) {
            this.namespaceIdentifier = namespaceIdentifier;
            return this;
        }

        public final String getWorkgroupIdentifier() {
            return this.workgroupIdentifier;
        }

        public final void setWorkgroupIdentifier(String workgroupIdentifier) {
            this.workgroupIdentifier = workgroupIdentifier;
        }

        @Override
        public final Builder workgroupIdentifier(String workgroupIdentifier) {
            this.workgroupIdentifier = workgroupIdentifier;
            return this;
        }

        public ServerlessIdentifier build() {
            return new ServerlessIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerlessIdentifier> {
        public Builder namespaceIdentifier(String var1);

        public Builder workgroupIdentifier(String var1);
    }
}

