/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.ReservedNode;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOffering;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedNodeConfigurationOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedNodeConfigurationOption> {
    private static final SdkField<ReservedNode> SOURCE_RESERVED_NODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceReservedNode").getter(ReservedNodeConfigurationOption.getter(ReservedNodeConfigurationOption::sourceReservedNode)).setter(ReservedNodeConfigurationOption.setter(Builder::sourceReservedNode)).constructor(ReservedNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceReservedNode").build()}).build();
    private static final SdkField<Integer> TARGET_RESERVED_NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetReservedNodeCount").getter(ReservedNodeConfigurationOption.getter(ReservedNodeConfigurationOption::targetReservedNodeCount)).setter(ReservedNodeConfigurationOption.setter(Builder::targetReservedNodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeCount").build()}).build();
    private static final SdkField<ReservedNodeOffering> TARGET_RESERVED_NODE_OFFERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetReservedNodeOffering").getter(ReservedNodeConfigurationOption.getter(ReservedNodeConfigurationOption::targetReservedNodeOffering)).setter(ReservedNodeConfigurationOption.setter(Builder::targetReservedNodeOffering)).constructor(ReservedNodeOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeOffering").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_RESERVED_NODE_FIELD, TARGET_RESERVED_NODE_COUNT_FIELD, TARGET_RESERVED_NODE_OFFERING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SourceReservedNode", SOURCE_RESERVED_NODE_FIELD);
            this.put("TargetReservedNodeCount", TARGET_RESERVED_NODE_COUNT_FIELD);
            this.put("TargetReservedNodeOffering", TARGET_RESERVED_NODE_OFFERING_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ReservedNode sourceReservedNode;
    private final Integer targetReservedNodeCount;
    private final ReservedNodeOffering targetReservedNodeOffering;

    private ReservedNodeConfigurationOption(BuilderImpl builder) {
        this.sourceReservedNode = builder.sourceReservedNode;
        this.targetReservedNodeCount = builder.targetReservedNodeCount;
        this.targetReservedNodeOffering = builder.targetReservedNodeOffering;
    }

    public final ReservedNode sourceReservedNode() {
        return this.sourceReservedNode;
    }

    public final Integer targetReservedNodeCount() {
        return this.targetReservedNodeCount;
    }

    public final ReservedNodeOffering targetReservedNodeOffering() {
        return this.targetReservedNodeOffering;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceReservedNode());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetReservedNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetReservedNodeOffering());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedNodeConfigurationOption)) {
            return false;
        }
        ReservedNodeConfigurationOption other = (ReservedNodeConfigurationOption)obj;
        return Objects.equals(this.sourceReservedNode(), other.sourceReservedNode()) && Objects.equals(this.targetReservedNodeCount(), other.targetReservedNodeCount()) && Objects.equals(this.targetReservedNodeOffering(), other.targetReservedNodeOffering());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedNodeConfigurationOption").add("SourceReservedNode", (Object)this.sourceReservedNode()).add("TargetReservedNodeCount", (Object)this.targetReservedNodeCount()).add("TargetReservedNodeOffering", (Object)this.targetReservedNodeOffering()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceReservedNode": {
                return Optional.ofNullable(clazz.cast(this.sourceReservedNode()));
            }
            case "TargetReservedNodeCount": {
                return Optional.ofNullable(clazz.cast(this.targetReservedNodeCount()));
            }
            case "TargetReservedNodeOffering": {
                return Optional.ofNullable(clazz.cast(this.targetReservedNodeOffering()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReservedNodeConfigurationOption, T> g) {
        return obj -> g.apply((ReservedNodeConfigurationOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ReservedNode sourceReservedNode;
        private Integer targetReservedNodeCount;
        private ReservedNodeOffering targetReservedNodeOffering;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedNodeConfigurationOption model) {
            this.sourceReservedNode(model.sourceReservedNode);
            this.targetReservedNodeCount(model.targetReservedNodeCount);
            this.targetReservedNodeOffering(model.targetReservedNodeOffering);
        }

        public final ReservedNode.Builder getSourceReservedNode() {
            return this.sourceReservedNode != null ? this.sourceReservedNode.toBuilder() : null;
        }

        public final void setSourceReservedNode(ReservedNode.BuilderImpl sourceReservedNode) {
            this.sourceReservedNode = sourceReservedNode != null ? sourceReservedNode.build() : null;
        }

        @Override
        public final Builder sourceReservedNode(ReservedNode sourceReservedNode) {
            this.sourceReservedNode = sourceReservedNode;
            return this;
        }

        public final Integer getTargetReservedNodeCount() {
            return this.targetReservedNodeCount;
        }

        public final void setTargetReservedNodeCount(Integer targetReservedNodeCount) {
            this.targetReservedNodeCount = targetReservedNodeCount;
        }

        @Override
        public final Builder targetReservedNodeCount(Integer targetReservedNodeCount) {
            this.targetReservedNodeCount = targetReservedNodeCount;
            return this;
        }

        public final ReservedNodeOffering.Builder getTargetReservedNodeOffering() {
            return this.targetReservedNodeOffering != null ? this.targetReservedNodeOffering.toBuilder() : null;
        }

        public final void setTargetReservedNodeOffering(ReservedNodeOffering.BuilderImpl targetReservedNodeOffering) {
            this.targetReservedNodeOffering = targetReservedNodeOffering != null ? targetReservedNodeOffering.build() : null;
        }

        @Override
        public final Builder targetReservedNodeOffering(ReservedNodeOffering targetReservedNodeOffering) {
            this.targetReservedNodeOffering = targetReservedNodeOffering;
            return this;
        }

        public ReservedNodeConfigurationOption build() {
            return new ReservedNodeConfigurationOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedNodeConfigurationOption> {
        public Builder sourceReservedNode(ReservedNode var1);

        default public Builder sourceReservedNode(Consumer<ReservedNode.Builder> sourceReservedNode) {
            return this.sourceReservedNode((ReservedNode)((ReservedNode.Builder)ReservedNode.builder().applyMutation(sourceReservedNode)).build());
        }

        public Builder targetReservedNodeCount(Integer var1);

        public Builder targetReservedNodeOffering(ReservedNodeOffering var1);

        default public Builder targetReservedNodeOffering(Consumer<ReservedNodeOffering.Builder> targetReservedNodeOffering) {
            return this.targetReservedNodeOffering((ReservedNodeOffering)((ReservedNodeOffering.Builder)ReservedNodeOffering.builder().applyMutation(targetReservedNodeOffering)).build());
        }
    }
}

