/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupNameListCopier;
import software.amazon.awssdk.services.redshift.model.IamRoleArnListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreFromClusterSnapshotRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, RestoreFromClusterSnapshotRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::clusterIdentifier)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotIdentifier").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::snapshotIdentifier)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::snapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build()}).build();
    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotArn").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::snapshotArn)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::snapshotArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArn").build()}).build();
    private static final SdkField<String> SNAPSHOT_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotClusterIdentifier").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::snapshotClusterIdentifier)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::snapshotClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotClusterIdentifier").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::port)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::availabilityZone)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<Boolean> ALLOW_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowVersionUpgrade").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::allowVersionUpgrade)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::allowVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowVersionUpgrade").build()}).build();
    private static final SdkField<String> CLUSTER_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterSubnetGroupName").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::clusterSubnetGroupName)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::clusterSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSubnetGroupName").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::publiclyAccessible)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccount").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::ownerAccount)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()}).build();
    private static final SdkField<String> HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmClientCertificateIdentifier").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::hsmClientCertificateIdentifier)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::hsmClientCertificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmClientCertificateIdentifier").build()}).build();
    private static final SdkField<String> HSM_CONFIGURATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmConfigurationIdentifier").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::hsmConfigurationIdentifier)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::hsmConfigurationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmConfigurationIdentifier").build()}).build();
    private static final SdkField<String> ELASTIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElasticIp").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::elasticIp)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::elasticIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticIp").build()}).build();
    private static final SdkField<String> CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterParameterGroupName").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::clusterParameterGroupName)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::clusterParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterGroupName").build()}).build();
    private static final SdkField<List<String>> CLUSTER_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterSecurityGroups").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::clusterSecurityGroups)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::clusterSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroups").build(), ListTrait.builder().memberLocationName("ClusterSecurityGroupName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroupName").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::vpcSecurityGroupIds)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::preferredMaintenanceWindow)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<Integer> AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutomatedSnapshotRetentionPeriod").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::automatedSnapshotRetentionPeriod)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::automatedSnapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomatedSnapshotRetentionPeriod").build()}).build();
    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ManualSnapshotRetentionPeriod").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::manualSnapshotRetentionPeriod)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::manualSnapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::kmsKeyId)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::nodeType)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnhancedVpcRouting").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::enhancedVpcRouting)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::enhancedVpcRouting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedVpcRouting").build()}).build();
    private static final SdkField<String> ADDITIONAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdditionalInfo").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::additionalInfo)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::additionalInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInfo").build()}).build();
    private static final SdkField<List<String>> IAM_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IamRoles").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::iamRoles)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::iamRoles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoles").build(), ListTrait.builder().memberLocationName("IamRoleArn").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build()).build()}).build();
    private static final SdkField<String> MAINTENANCE_TRACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceTrackName").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::maintenanceTrackName)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::maintenanceTrackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrackName").build()}).build();
    private static final SdkField<String> SNAPSHOT_SCHEDULE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotScheduleIdentifier").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::snapshotScheduleIdentifier)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::snapshotScheduleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotScheduleIdentifier").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfNodes").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::numberOfNodes)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::numberOfNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()}).build();
    private static final SdkField<Boolean> AVAILABILITY_ZONE_RELOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AvailabilityZoneRelocation").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::availabilityZoneRelocation)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::availabilityZoneRelocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneRelocation").build()}).build();
    private static final SdkField<String> AQUA_CONFIGURATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AquaConfigurationStatus").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::aquaConfigurationStatusAsString)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::aquaConfigurationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AquaConfigurationStatus").build()}).build();
    private static final SdkField<String> DEFAULT_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultIamRoleArn").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::defaultIamRoleArn)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::defaultIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultIamRoleArn").build()}).build();
    private static final SdkField<String> RESERVED_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedNodeId").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::reservedNodeId)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::reservedNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeId").build()}).build();
    private static final SdkField<String> TARGET_RESERVED_NODE_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetReservedNodeOfferingId").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::targetReservedNodeOfferingId)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::targetReservedNodeOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeOfferingId").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::encrypted)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<Boolean> MANAGE_MASTER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ManageMasterPassword").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::manageMasterPassword)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::manageMasterPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManageMasterPassword").build()}).build();
    private static final SdkField<String> MASTER_PASSWORD_SECRET_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterPasswordSecretKmsKeyId").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::masterPasswordSecretKmsKeyId)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::masterPasswordSecretKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterPasswordSecretKmsKeyId").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressType").getter(RestoreFromClusterSnapshotRequest.getter(RestoreFromClusterSnapshotRequest::ipAddressType)).setter(RestoreFromClusterSnapshotRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, SNAPSHOT_IDENTIFIER_FIELD, SNAPSHOT_ARN_FIELD, SNAPSHOT_CLUSTER_IDENTIFIER_FIELD, PORT_FIELD, AVAILABILITY_ZONE_FIELD, ALLOW_VERSION_UPGRADE_FIELD, CLUSTER_SUBNET_GROUP_NAME_FIELD, PUBLICLY_ACCESSIBLE_FIELD, OWNER_ACCOUNT_FIELD, HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD, HSM_CONFIGURATION_IDENTIFIER_FIELD, ELASTIC_IP_FIELD, CLUSTER_PARAMETER_GROUP_NAME_FIELD, CLUSTER_SECURITY_GROUPS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD, MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD, KMS_KEY_ID_FIELD, NODE_TYPE_FIELD, ENHANCED_VPC_ROUTING_FIELD, ADDITIONAL_INFO_FIELD, IAM_ROLES_FIELD, MAINTENANCE_TRACK_NAME_FIELD, SNAPSHOT_SCHEDULE_IDENTIFIER_FIELD, NUMBER_OF_NODES_FIELD, AVAILABILITY_ZONE_RELOCATION_FIELD, AQUA_CONFIGURATION_STATUS_FIELD, DEFAULT_IAM_ROLE_ARN_FIELD, RESERVED_NODE_ID_FIELD, TARGET_RESERVED_NODE_OFFERING_ID_FIELD, ENCRYPTED_FIELD, MANAGE_MASTER_PASSWORD_FIELD, MASTER_PASSWORD_SECRET_KMS_KEY_ID_FIELD, IP_ADDRESS_TYPE_FIELD));
    private final String clusterIdentifier;
    private final String snapshotIdentifier;
    private final String snapshotArn;
    private final String snapshotClusterIdentifier;
    private final Integer port;
    private final String availabilityZone;
    private final Boolean allowVersionUpgrade;
    private final String clusterSubnetGroupName;
    private final Boolean publiclyAccessible;
    private final String ownerAccount;
    private final String hsmClientCertificateIdentifier;
    private final String hsmConfigurationIdentifier;
    private final String elasticIp;
    private final String clusterParameterGroupName;
    private final List<String> clusterSecurityGroups;
    private final List<String> vpcSecurityGroupIds;
    private final String preferredMaintenanceWindow;
    private final Integer automatedSnapshotRetentionPeriod;
    private final Integer manualSnapshotRetentionPeriod;
    private final String kmsKeyId;
    private final String nodeType;
    private final Boolean enhancedVpcRouting;
    private final String additionalInfo;
    private final List<String> iamRoles;
    private final String maintenanceTrackName;
    private final String snapshotScheduleIdentifier;
    private final Integer numberOfNodes;
    private final Boolean availabilityZoneRelocation;
    private final String aquaConfigurationStatus;
    private final String defaultIamRoleArn;
    private final String reservedNodeId;
    private final String targetReservedNodeOfferingId;
    private final Boolean encrypted;
    private final Boolean manageMasterPassword;
    private final String masterPasswordSecretKmsKeyId;
    private final String ipAddressType;

    private RestoreFromClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotArn = builder.snapshotArn;
        this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.allowVersionUpgrade = builder.allowVersionUpgrade;
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.ownerAccount = builder.ownerAccount;
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.elasticIp = builder.elasticIp;
        this.clusterParameterGroupName = builder.clusterParameterGroupName;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.kmsKeyId = builder.kmsKeyId;
        this.nodeType = builder.nodeType;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.additionalInfo = builder.additionalInfo;
        this.iamRoles = builder.iamRoles;
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.snapshotScheduleIdentifier = builder.snapshotScheduleIdentifier;
        this.numberOfNodes = builder.numberOfNodes;
        this.availabilityZoneRelocation = builder.availabilityZoneRelocation;
        this.aquaConfigurationStatus = builder.aquaConfigurationStatus;
        this.defaultIamRoleArn = builder.defaultIamRoleArn;
        this.reservedNodeId = builder.reservedNodeId;
        this.targetReservedNodeOfferingId = builder.targetReservedNodeOfferingId;
        this.encrypted = builder.encrypted;
        this.manageMasterPassword = builder.manageMasterPassword;
        this.masterPasswordSecretKmsKeyId = builder.masterPasswordSecretKmsKeyId;
        this.ipAddressType = builder.ipAddressType;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public final String snapshotArn() {
        return this.snapshotArn;
    }

    public final String snapshotClusterIdentifier() {
        return this.snapshotClusterIdentifier;
    }

    public final Integer port() {
        return this.port;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Boolean allowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public final String clusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final String hsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public final String hsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public final String elasticIp() {
        return this.elasticIp;
    }

    public final String clusterParameterGroupName() {
        return this.clusterParameterGroupName;
    }

    public final boolean hasClusterSecurityGroups() {
        return this.clusterSecurityGroups != null && !(this.clusterSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> clusterSecurityGroups() {
        return this.clusterSecurityGroups;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final Integer automatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public final Integer manualSnapshotRetentionPeriod() {
        return this.manualSnapshotRetentionPeriod;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public final String additionalInfo() {
        return this.additionalInfo;
    }

    public final boolean hasIamRoles() {
        return this.iamRoles != null && !(this.iamRoles instanceof SdkAutoConstructList);
    }

    public final List<String> iamRoles() {
        return this.iamRoles;
    }

    public final String maintenanceTrackName() {
        return this.maintenanceTrackName;
    }

    public final String snapshotScheduleIdentifier() {
        return this.snapshotScheduleIdentifier;
    }

    public final Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public final Boolean availabilityZoneRelocation() {
        return this.availabilityZoneRelocation;
    }

    public final AquaConfigurationStatus aquaConfigurationStatus() {
        return AquaConfigurationStatus.fromValue(this.aquaConfigurationStatus);
    }

    public final String aquaConfigurationStatusAsString() {
        return this.aquaConfigurationStatus;
    }

    public final String defaultIamRoleArn() {
        return this.defaultIamRoleArn;
    }

    public final String reservedNodeId() {
        return this.reservedNodeId;
    }

    public final String targetReservedNodeOfferingId() {
        return this.targetReservedNodeOfferingId;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final Boolean manageMasterPassword() {
        return this.manageMasterPassword;
    }

    public final String masterPasswordSecretKmsKeyId() {
        return this.masterPasswordSecretKmsKeyId;
    }

    public final String ipAddressType() {
        return this.ipAddressType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmClientCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterSecurityGroups() ? this.clusterSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.automatedSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIamRoles() ? this.iamRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotScheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneRelocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.aquaConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetReservedNodeOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.manageMasterPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterPasswordSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreFromClusterSnapshotRequest)) {
            return false;
        }
        RestoreFromClusterSnapshotRequest other = (RestoreFromClusterSnapshotRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(this.snapshotArn(), other.snapshotArn()) && Objects.equals(this.snapshotClusterIdentifier(), other.snapshotClusterIdentifier()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.allowVersionUpgrade(), other.allowVersionUpgrade()) && Objects.equals(this.clusterSubnetGroupName(), other.clusterSubnetGroupName()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.hsmClientCertificateIdentifier(), other.hsmClientCertificateIdentifier()) && Objects.equals(this.hsmConfigurationIdentifier(), other.hsmConfigurationIdentifier()) && Objects.equals(this.elasticIp(), other.elasticIp()) && Objects.equals(this.clusterParameterGroupName(), other.clusterParameterGroupName()) && this.hasClusterSecurityGroups() == other.hasClusterSecurityGroups() && Objects.equals(this.clusterSecurityGroups(), other.clusterSecurityGroups()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.automatedSnapshotRetentionPeriod(), other.automatedSnapshotRetentionPeriod()) && Objects.equals(this.manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.enhancedVpcRouting(), other.enhancedVpcRouting()) && Objects.equals(this.additionalInfo(), other.additionalInfo()) && this.hasIamRoles() == other.hasIamRoles() && Objects.equals(this.iamRoles(), other.iamRoles()) && Objects.equals(this.maintenanceTrackName(), other.maintenanceTrackName()) && Objects.equals(this.snapshotScheduleIdentifier(), other.snapshotScheduleIdentifier()) && Objects.equals(this.numberOfNodes(), other.numberOfNodes()) && Objects.equals(this.availabilityZoneRelocation(), other.availabilityZoneRelocation()) && Objects.equals(this.aquaConfigurationStatusAsString(), other.aquaConfigurationStatusAsString()) && Objects.equals(this.defaultIamRoleArn(), other.defaultIamRoleArn()) && Objects.equals(this.reservedNodeId(), other.reservedNodeId()) && Objects.equals(this.targetReservedNodeOfferingId(), other.targetReservedNodeOfferingId()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.manageMasterPassword(), other.manageMasterPassword()) && Objects.equals(this.masterPasswordSecretKmsKeyId(), other.masterPasswordSecretKmsKeyId()) && Objects.equals(this.ipAddressType(), other.ipAddressType());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreFromClusterSnapshotRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("SnapshotIdentifier", (Object)this.snapshotIdentifier()).add("SnapshotArn", (Object)this.snapshotArn()).add("SnapshotClusterIdentifier", (Object)this.snapshotClusterIdentifier()).add("Port", (Object)this.port()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AllowVersionUpgrade", (Object)this.allowVersionUpgrade()).add("ClusterSubnetGroupName", (Object)this.clusterSubnetGroupName()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("OwnerAccount", (Object)this.ownerAccount()).add("HsmClientCertificateIdentifier", (Object)this.hsmClientCertificateIdentifier()).add("HsmConfigurationIdentifier", (Object)this.hsmConfigurationIdentifier()).add("ElasticIp", (Object)this.elasticIp()).add("ClusterParameterGroupName", (Object)this.clusterParameterGroupName()).add("ClusterSecurityGroups", this.hasClusterSecurityGroups() ? this.clusterSecurityGroups() : null).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("AutomatedSnapshotRetentionPeriod", (Object)this.automatedSnapshotRetentionPeriod()).add("ManualSnapshotRetentionPeriod", (Object)this.manualSnapshotRetentionPeriod()).add("KmsKeyId", (Object)this.kmsKeyId()).add("NodeType", (Object)this.nodeType()).add("EnhancedVpcRouting", (Object)this.enhancedVpcRouting()).add("AdditionalInfo", (Object)this.additionalInfo()).add("IamRoles", this.hasIamRoles() ? this.iamRoles() : null).add("MaintenanceTrackName", (Object)this.maintenanceTrackName()).add("SnapshotScheduleIdentifier", (Object)this.snapshotScheduleIdentifier()).add("NumberOfNodes", (Object)this.numberOfNodes()).add("AvailabilityZoneRelocation", (Object)this.availabilityZoneRelocation()).add("AquaConfigurationStatus", (Object)this.aquaConfigurationStatusAsString()).add("DefaultIamRoleArn", (Object)this.defaultIamRoleArn()).add("ReservedNodeId", (Object)this.reservedNodeId()).add("TargetReservedNodeOfferingId", (Object)this.targetReservedNodeOfferingId()).add("Encrypted", (Object)this.encrypted()).add("ManageMasterPassword", (Object)this.manageMasterPassword()).add("MasterPasswordSecretKmsKeyId", (Object)this.masterPasswordSecretKmsKeyId()).add("IpAddressType", (Object)this.ipAddressType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "SnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotIdentifier()));
            }
            case "SnapshotArn": {
                return Optional.ofNullable(clazz.cast(this.snapshotArn()));
            }
            case "SnapshotClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotClusterIdentifier()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AllowVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.allowVersionUpgrade()));
            }
            case "ClusterSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.clusterSubnetGroupName()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "OwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "HsmClientCertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.hsmClientCertificateIdentifier()));
            }
            case "HsmConfigurationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.hsmConfigurationIdentifier()));
            }
            case "ElasticIp": {
                return Optional.ofNullable(clazz.cast(this.elasticIp()));
            }
            case "ClusterParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.clusterParameterGroupName()));
            }
            case "ClusterSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.clusterSecurityGroups()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "AutomatedSnapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.automatedSnapshotRetentionPeriod()));
            }
            case "ManualSnapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.manualSnapshotRetentionPeriod()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "EnhancedVpcRouting": {
                return Optional.ofNullable(clazz.cast(this.enhancedVpcRouting()));
            }
            case "AdditionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
            case "IamRoles": {
                return Optional.ofNullable(clazz.cast(this.iamRoles()));
            }
            case "MaintenanceTrackName": {
                return Optional.ofNullable(clazz.cast(this.maintenanceTrackName()));
            }
            case "SnapshotScheduleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotScheduleIdentifier()));
            }
            case "NumberOfNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfNodes()));
            }
            case "AvailabilityZoneRelocation": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneRelocation()));
            }
            case "AquaConfigurationStatus": {
                return Optional.ofNullable(clazz.cast(this.aquaConfigurationStatusAsString()));
            }
            case "DefaultIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.defaultIamRoleArn()));
            }
            case "ReservedNodeId": {
                return Optional.ofNullable(clazz.cast(this.reservedNodeId()));
            }
            case "TargetReservedNodeOfferingId": {
                return Optional.ofNullable(clazz.cast(this.targetReservedNodeOfferingId()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "ManageMasterPassword": {
                return Optional.ofNullable(clazz.cast(this.manageMasterPassword()));
            }
            case "MasterPasswordSecretKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.masterPasswordSecretKmsKeyId()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreFromClusterSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreFromClusterSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String snapshotIdentifier;
        private String snapshotArn;
        private String snapshotClusterIdentifier;
        private Integer port;
        private String availabilityZone;
        private Boolean allowVersionUpgrade;
        private String clusterSubnetGroupName;
        private Boolean publiclyAccessible;
        private String ownerAccount;
        private String hsmClientCertificateIdentifier;
        private String hsmConfigurationIdentifier;
        private String elasticIp;
        private String clusterParameterGroupName;
        private List<String> clusterSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String preferredMaintenanceWindow;
        private Integer automatedSnapshotRetentionPeriod;
        private Integer manualSnapshotRetentionPeriod;
        private String kmsKeyId;
        private String nodeType;
        private Boolean enhancedVpcRouting;
        private String additionalInfo;
        private List<String> iamRoles = DefaultSdkAutoConstructList.getInstance();
        private String maintenanceTrackName;
        private String snapshotScheduleIdentifier;
        private Integer numberOfNodes;
        private Boolean availabilityZoneRelocation;
        private String aquaConfigurationStatus;
        private String defaultIamRoleArn;
        private String reservedNodeId;
        private String targetReservedNodeOfferingId;
        private Boolean encrypted;
        private Boolean manageMasterPassword;
        private String masterPasswordSecretKmsKeyId;
        private String ipAddressType;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreFromClusterSnapshotRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.snapshotArn(model.snapshotArn);
            this.snapshotClusterIdentifier(model.snapshotClusterIdentifier);
            this.port(model.port);
            this.availabilityZone(model.availabilityZone);
            this.allowVersionUpgrade(model.allowVersionUpgrade);
            this.clusterSubnetGroupName(model.clusterSubnetGroupName);
            this.publiclyAccessible(model.publiclyAccessible);
            this.ownerAccount(model.ownerAccount);
            this.hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            this.hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            this.elasticIp(model.elasticIp);
            this.clusterParameterGroupName(model.clusterParameterGroupName);
            this.clusterSecurityGroups(model.clusterSecurityGroups);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.automatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            this.manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            this.kmsKeyId(model.kmsKeyId);
            this.nodeType(model.nodeType);
            this.enhancedVpcRouting(model.enhancedVpcRouting);
            this.additionalInfo(model.additionalInfo);
            this.iamRoles(model.iamRoles);
            this.maintenanceTrackName(model.maintenanceTrackName);
            this.snapshotScheduleIdentifier(model.snapshotScheduleIdentifier);
            this.numberOfNodes(model.numberOfNodes);
            this.availabilityZoneRelocation(model.availabilityZoneRelocation);
            this.aquaConfigurationStatus(model.aquaConfigurationStatus);
            this.defaultIamRoleArn(model.defaultIamRoleArn);
            this.reservedNodeId(model.reservedNodeId);
            this.targetReservedNodeOfferingId(model.targetReservedNodeOfferingId);
            this.encrypted(model.encrypted);
            this.manageMasterPassword(model.manageMasterPassword);
            this.masterPasswordSecretKmsKeyId(model.masterPasswordSecretKmsKeyId);
            this.ipAddressType(model.ipAddressType);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getSnapshotArn() {
            return this.snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final String getSnapshotClusterIdentifier() {
            return this.snapshotClusterIdentifier;
        }

        public final void setSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
        }

        @Override
        public final Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Boolean getAllowVersionUpgrade() {
            return this.allowVersionUpgrade;
        }

        public final void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
        }

        @Override
        public final Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public final String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final String getHsmConfigurationIdentifier() {
            return this.hsmConfigurationIdentifier;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final String getElasticIp() {
            return this.elasticIp;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final String getClusterParameterGroupName() {
            return this.clusterParameterGroupName;
        }

        public final void setClusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
        }

        @Override
        public final Builder clusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
            return this;
        }

        public final Collection<String> getClusterSecurityGroups() {
            if (this.clusterSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clusterSecurityGroups;
        }

        public final void setClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(String ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return this.automatedSnapshotRetentionPeriod;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return this.manualSnapshotRetentionPeriod;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final Collection<String> getIamRoles() {
            if (this.iamRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.iamRoles;
        }

        public final void setIamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
        }

        @Override
        public final Builder iamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(String ... iamRoles) {
            this.iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        public final String getMaintenanceTrackName() {
            return this.maintenanceTrackName;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final String getSnapshotScheduleIdentifier() {
            return this.snapshotScheduleIdentifier;
        }

        public final void setSnapshotScheduleIdentifier(String snapshotScheduleIdentifier) {
            this.snapshotScheduleIdentifier = snapshotScheduleIdentifier;
        }

        @Override
        public final Builder snapshotScheduleIdentifier(String snapshotScheduleIdentifier) {
            this.snapshotScheduleIdentifier = snapshotScheduleIdentifier;
            return this;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final Boolean getAvailabilityZoneRelocation() {
            return this.availabilityZoneRelocation;
        }

        public final void setAvailabilityZoneRelocation(Boolean availabilityZoneRelocation) {
            this.availabilityZoneRelocation = availabilityZoneRelocation;
        }

        @Override
        public final Builder availabilityZoneRelocation(Boolean availabilityZoneRelocation) {
            this.availabilityZoneRelocation = availabilityZoneRelocation;
            return this;
        }

        public final String getAquaConfigurationStatus() {
            return this.aquaConfigurationStatus;
        }

        public final void setAquaConfigurationStatus(String aquaConfigurationStatus) {
            this.aquaConfigurationStatus = aquaConfigurationStatus;
        }

        @Override
        public final Builder aquaConfigurationStatus(String aquaConfigurationStatus) {
            this.aquaConfigurationStatus = aquaConfigurationStatus;
            return this;
        }

        @Override
        public final Builder aquaConfigurationStatus(AquaConfigurationStatus aquaConfigurationStatus) {
            this.aquaConfigurationStatus(aquaConfigurationStatus == null ? null : aquaConfigurationStatus.toString());
            return this;
        }

        public final String getDefaultIamRoleArn() {
            return this.defaultIamRoleArn;
        }

        public final void setDefaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
        }

        @Override
        public final Builder defaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
            return this;
        }

        public final String getReservedNodeId() {
            return this.reservedNodeId;
        }

        public final void setReservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
        }

        @Override
        public final Builder reservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
            return this;
        }

        public final String getTargetReservedNodeOfferingId() {
            return this.targetReservedNodeOfferingId;
        }

        public final void setTargetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
        }

        @Override
        public final Builder targetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final Boolean getManageMasterPassword() {
            return this.manageMasterPassword;
        }

        public final void setManageMasterPassword(Boolean manageMasterPassword) {
            this.manageMasterPassword = manageMasterPassword;
        }

        @Override
        public final Builder manageMasterPassword(Boolean manageMasterPassword) {
            this.manageMasterPassword = manageMasterPassword;
            return this;
        }

        public final String getMasterPasswordSecretKmsKeyId() {
            return this.masterPasswordSecretKmsKeyId;
        }

        public final void setMasterPasswordSecretKmsKeyId(String masterPasswordSecretKmsKeyId) {
            this.masterPasswordSecretKmsKeyId = masterPasswordSecretKmsKeyId;
        }

        @Override
        public final Builder masterPasswordSecretKmsKeyId(String masterPasswordSecretKmsKeyId) {
            this.masterPasswordSecretKmsKeyId = masterPasswordSecretKmsKeyId;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreFromClusterSnapshotRequest build() {
            return new RestoreFromClusterSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreFromClusterSnapshotRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder snapshotIdentifier(String var1);

        public Builder snapshotArn(String var1);

        public Builder snapshotClusterIdentifier(String var1);

        public Builder port(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder allowVersionUpgrade(Boolean var1);

        public Builder clusterSubnetGroupName(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder ownerAccount(String var1);

        public Builder hsmClientCertificateIdentifier(String var1);

        public Builder hsmConfigurationIdentifier(String var1);

        public Builder elasticIp(String var1);

        public Builder clusterParameterGroupName(String var1);

        public Builder clusterSecurityGroups(Collection<String> var1);

        public Builder clusterSecurityGroups(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder automatedSnapshotRetentionPeriod(Integer var1);

        public Builder manualSnapshotRetentionPeriod(Integer var1);

        public Builder kmsKeyId(String var1);

        public Builder nodeType(String var1);

        public Builder enhancedVpcRouting(Boolean var1);

        public Builder additionalInfo(String var1);

        public Builder iamRoles(Collection<String> var1);

        public Builder iamRoles(String ... var1);

        public Builder maintenanceTrackName(String var1);

        public Builder snapshotScheduleIdentifier(String var1);

        public Builder numberOfNodes(Integer var1);

        public Builder availabilityZoneRelocation(Boolean var1);

        public Builder aquaConfigurationStatus(String var1);

        public Builder aquaConfigurationStatus(AquaConfigurationStatus var1);

        public Builder defaultIamRoleArn(String var1);

        public Builder reservedNodeId(String var1);

        public Builder targetReservedNodeOfferingId(String var1);

        public Builder encrypted(Boolean var1);

        public Builder manageMasterPassword(Boolean var1);

        public Builder masterPasswordSecretKmsKeyId(String var1);

        public Builder ipAddressType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

