/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DataShare;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerResponse;

public class DescribeDataSharesForConsumerPublisher
implements SdkPublisher<DescribeDataSharesForConsumerResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeDataSharesForConsumerRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDataSharesForConsumerPublisher(RedshiftAsyncClient client, DescribeDataSharesForConsumerRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDataSharesForConsumerPublisher(RedshiftAsyncClient client, DescribeDataSharesForConsumerRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDataSharesForConsumerResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDataSharesForConsumerResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataShare> dataShares() {
        Function<DescribeDataSharesForConsumerResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataShares() != null) {
                return response.dataShares().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDataSharesForConsumerResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDataSharesForConsumerResponseFetcher
    implements AsyncPageFetcher<DescribeDataSharesForConsumerResponse> {
        private DescribeDataSharesForConsumerResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataSharesForConsumerResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDataSharesForConsumerResponse> nextPage(DescribeDataSharesForConsumerResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataSharesForConsumerPublisher.this.client.describeDataSharesForConsumer(DescribeDataSharesForConsumerPublisher.this.firstRequest);
            }
            return DescribeDataSharesForConsumerPublisher.this.client.describeDataSharesForConsumer((DescribeDataSharesForConsumerRequest)((Object)DescribeDataSharesForConsumerPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

