/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataSharesForConsumerResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeDataSharesForConsumerResponse.Builder, DescribeDataSharesForConsumerResponse> {
    private static final SdkField<List<DataShare>> DATA_SHARES_FIELD = SdkField
            .<List<DataShare>> builder(MarshallingType.LIST)
            .memberName("DataShares")
            .getter(getter(DescribeDataSharesForConsumerResponse::dataShares))
            .setter(setter(Builder::dataShares))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataShares").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataShare> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataShare::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDataSharesForConsumerResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SHARES_FIELD,
            MARKER_FIELD));

    private final List<DataShare> dataShares;

    private final String marker;

    private DescribeDataSharesForConsumerResponse(BuilderImpl builder) {
        super(builder);
        this.dataShares = builder.dataShares;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataShares property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDataShares() {
        return dataShares != null && !(dataShares instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Shows the results of datashares available for consumers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataShares} method.
     * </p>
     * 
     * @return Shows the results of datashares available for consumers.
     */
    public final List<DataShare> dataShares() {
        return dataShares;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point to return a set of response records. When the results of
     * a <a>DescribeDataSharesForConsumer</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web
     * Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of
     * response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the
     * request.
     * </p>
     * 
     * @return An optional parameter that specifies the starting point to return a set of response records. When the
     *         results of a <a>DescribeDataSharesForConsumer</a> request exceed the value specified in
     *         <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the
     *         response. You can retrieve the next set of response records by providing the returned marker value in the
     *         <code>Marker</code> parameter and retrying the request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDataShares() ? dataShares() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSharesForConsumerResponse)) {
            return false;
        }
        DescribeDataSharesForConsumerResponse other = (DescribeDataSharesForConsumerResponse) obj;
        return hasDataShares() == other.hasDataShares() && Objects.equals(dataShares(), other.dataShares())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDataSharesForConsumerResponse").add("DataShares", hasDataShares() ? dataShares() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataShares":
            return Optional.ofNullable(clazz.cast(dataShares()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataSharesForConsumerResponse, T> g) {
        return obj -> g.apply((DescribeDataSharesForConsumerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDataSharesForConsumerResponse> {
        /**
         * <p>
         * Shows the results of datashares available for consumers.
         * </p>
         * 
         * @param dataShares
         *        Shows the results of datashares available for consumers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataShares(Collection<DataShare> dataShares);

        /**
         * <p>
         * Shows the results of datashares available for consumers.
         * </p>
         * 
         * @param dataShares
         *        Shows the results of datashares available for consumers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataShares(DataShare... dataShares);

        /**
         * <p>
         * Shows the results of datashares available for consumers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.DataShare.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.redshift.model.DataShare#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.DataShare.Builder#build()} is called immediately and
         * its result is passed to {@link #dataShares(List<DataShare>)}.
         * 
         * @param dataShares
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.DataShare.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataShares(java.util.Collection<DataShare>)
         */
        Builder dataShares(Consumer<DataShare.Builder>... dataShares);

        /**
         * <p>
         * An optional parameter that specifies the starting point to return a set of response records. When the results
         * of a <a>DescribeDataSharesForConsumer</a> request exceed the value specified in <code>MaxRecords</code>,
         * Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the
         * next set of response records by providing the returned marker value in the <code>Marker</code> parameter and
         * retrying the request.
         * </p>
         * 
         * @param marker
         *        An optional parameter that specifies the starting point to return a set of response records. When the
         *        results of a <a>DescribeDataSharesForConsumer</a> request exceed the value specified in
         *        <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the
         *        response. You can retrieve the next set of response records by providing the returned marker value in
         *        the <code>Marker</code> parameter and retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<DataShare> dataShares = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataSharesForConsumerResponse model) {
            super(model);
            dataShares(model.dataShares);
            marker(model.marker);
        }

        public final List<DataShare.Builder> getDataShares() {
            List<DataShare.Builder> result = DataShareListCopier.copyToBuilder(this.dataShares);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataShares(Collection<DataShare.BuilderImpl> dataShares) {
            this.dataShares = DataShareListCopier.copyFromBuilder(dataShares);
        }

        @Override
        public final Builder dataShares(Collection<DataShare> dataShares) {
            this.dataShares = DataShareListCopier.copy(dataShares);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataShares(DataShare... dataShares) {
            dataShares(Arrays.asList(dataShares));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataShares(Consumer<DataShare.Builder>... dataShares) {
            dataShares(Stream.of(dataShares).map(c -> DataShare.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeDataSharesForConsumerResponse build() {
            return new DescribeDataSharesForConsumerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
