/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOffering;

public class GetReservedNodeExchangeOfferingsIterable
implements SdkIterable<GetReservedNodeExchangeOfferingsResponse> {
    private final RedshiftClient client;
    private final GetReservedNodeExchangeOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetReservedNodeExchangeOfferingsIterable(RedshiftClient client, GetReservedNodeExchangeOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetReservedNodeExchangeOfferingsResponseFetcher();
    }

    public Iterator<GetReservedNodeExchangeOfferingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservedNodeOffering> reservedNodeOfferings() {
        Function<GetReservedNodeExchangeOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodeOfferings() != null) {
                return response.reservedNodeOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetReservedNodeExchangeOfferingsResponseFetcher
    implements SyncPageFetcher<GetReservedNodeExchangeOfferingsResponse> {
        private GetReservedNodeExchangeOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(GetReservedNodeExchangeOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public GetReservedNodeExchangeOfferingsResponse nextPage(GetReservedNodeExchangeOfferingsResponse previousPage) {
            if (previousPage == null) {
                return GetReservedNodeExchangeOfferingsIterable.this.client.getReservedNodeExchangeOfferings(GetReservedNodeExchangeOfferingsIterable.this.firstRequest);
            }
            return GetReservedNodeExchangeOfferingsIterable.this.client.getReservedNodeExchangeOfferings((GetReservedNodeExchangeOfferingsRequest)((Object)GetReservedNodeExchangeOfferingsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

